#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 13402 2022-04-05 17:29:36Z Jacky $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Jacky $
# $Date: 2022-04-06 01:29:36 +0800 (Wed, 06 Apr 2022) $
# $Revision: 13402 $

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.template.loader import select_template

from Zephyrus.comment import settings as _settings
from Zephyrus.comment.models import (
    CommentPlugin, Comment, RecentResponsePlugin, CommentConfig)
from Zephyrus.comment.forms import CommentForm

class CMSCommentPlugin(CMSPluginBase):
    model = CommentPlugin
    module = _("Comment")
    name = _("Comment")
    render_template =_settings.ZEPHYRUS_COMMENT_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
        ] + [template[0] for template in _settings.ZEPHYRUS_COMMENT_TEMPLATES]
        )

    def render(self, context, instance, placeholder):
        request = context['request']
        url = request.build_absolute_uri(request.path)

        comments = Comment.objects.filter(url=url, display=True, facebook=False)

        obj, created = CommentConfig.objects.get_or_create(
            url=url,
            defaults={'useFbComment': False},
        )
        obj.useFbComment = instance.useFbComment
        obj.save()

        context.update({
            'plugin': instance,
            'url': url,
            'comments': comments,
            'form': CommentForm(),
        })
        return context

class CMSRecentResponsePlugin(CMSPluginBase):
    model = RecentResponsePlugin
    module = _("Comment")
    name = _("Recent Response")
    render_template = _settings.ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            _settings.ZEPHYRUS_RECENTRESPONSE_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        comments = Comment.objects.order_by('-createDate')

        if comments.count() >= instance.limit:
            comments = comments[:instance.limit]
        else:
            comments = comments

        context.update({
            'comments': comments,
        })
        return context

plugin_pool.register_plugin(CMSCommentPlugin)
plugin_pool.register_plugin(CMSRecentResponsePlugin)