# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('cms', '0016_auto_20160608_1535'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('url', models.CharField(max_length=100, null=True, editable=False)),
                ('email', models.EmailField(max_length=254, null=True, blank=True)),
                ('message', models.TextField()),
                ('user', models.ForeignKey(blank=True, to=settings.AUTH_USER_MODEL, null=True, on_delete=models.CASCADE)),
            ],
        ),
        migrations.CreateModel(
            name='CommentPlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(parent_link=True, related_name='comment_commentplugin', auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin', on_delete=models.CASCADE)),
                ('useFbComment', models.BooleanField(verbose_name='Use Facebook Comment')),
                ('renderTemplate', models.CharField(default=b'comment/Default.html', max_length=150, verbose_name='Comment Template', blank=True, choices=[(b'comment/Default.html', 'Default'), (b'aldryn_newsblog/blog/Comment.html', b'Blog')])),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
