#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 13421 2022-04-19 08:37:17Z Jacky $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Jacky $
# $Date: 2022-04-19 16:37:17 +0800 (Tue, 19 Apr 2022) $
# $Revision: 13421 $


from django.db import models
from django.utils.translation import ugettext_lazy as _

from cms.models import CMSPlugin

from Zephyrus.map import settings



class Map(CMSPlugin):
    apiKey = models.CharField(_('API Key'), max_length=100)
    renderTemplate = models.CharField(
        _('Map Template'), max_length=250, blank=True,
        choices=settings.MAP_TEMPLATES,
        default=settings.MAP_DEFAULT_TEMPLATE,
    )

    def copy_relations(self, oldinstance):
        # Before copying related objects from the old instance, the ones
        # on the current one need to be deleted. Otherwise, duplicates may
        # appear on the public version of the page
        # Reference: https://docs.django-cms.org/en/latest/how_to/custom_plugins.html#handling-relations
        self.positions.all().delete()

        for positions in oldinstance.positions.all():
            # instance.pk = None; instance.pk.save() is the slightly odd but
            # standard Django way of copying a saved model instance
            positions.pk = None
            positions.relatedMap = self
            positions.save()

    class Meta:
        verbose_name = _("Map")
        verbose_name_plural = _("Map")


class MapPosition(models.Model):
    relatedMap = models.ForeignKey(Map, related_name="positions", on_delete=models.CASCADE)
    region = models.CharField(max_length=60, null=True, blank=True)
    name = models.CharField(max_length=200, null=True, blank=True)
    tel = models.CharField(max_length=60, null=True, blank=True)
    email = models.CharField(max_length=60, null=True, blank=True)
    address = models.CharField(max_length=1000, null=True, blank=True)
    coordinate = models.CharField(max_length=100)

    class Meta:
        verbose_name_plural = _('Positions')
        verbose_name = _('Positions')

    def __str__(self):
        representative = self.name if self.name else "#" + str(self.id)
        return representative + " | Map:" + str(self.relatedMap.id)

