#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: lookups.py 10797 2018-03-01 02:31:02Z David $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-01 10:31:02 +0800 (Thu, 01 Mar 2018) $
# $Revision: 10797 $


from selectable.base import ModelLookup
from selectable.registry import registry

from emencia.django.newsletter.models import Newsletter

from Theophrastus.newsletter_extension.models import Header, Footer

class SenderLookup(ModelLookup):
    model = Newsletter
    search_fields = ('header_sender__icontains', )

    def get_item_value(self, item):
        return item.header_sender

    def get_item_label(self, item):
        return item.header_sender

    def format_results(self, raw_data, options):
        results = super(SenderLookup, self).format_results(raw_data, options)
        results['data'] = {v['value']:v for v in results['data']}.values()
        return results

class ReplyLookup(ModelLookup):
    model = Newsletter
    search_fields = ('header_reply__icontains', )

    def get_item_value(self, item):
        return item.header_reply

    def get_item_label(self, item):
        return item.header_reply

    def format_results(self, raw_data, options):
        results = super(ReplyLookup, self).format_results(raw_data, options)
        results['data'] = {v['value']:v for v in results['data']}.values()
        return results

class FooterLookup(ModelLookup):
    model = Footer
    search_fields = ('title__icontains', )

    def get_item_value(self, item):
        return item.title

    def get_item_label(self, item):
        return item.title

    def format_results(self, raw_data, options):
        results = super(FooterLookup, self).format_results(raw_data, options)
        results['data'] = {v['value']:v for v in results['data']}.values()
        return results

class HeaderLookup(ModelLookup):
    model = Header
    search_fields = ('title__icontains', )

    def get_item_value(self, item):
        return item.title

    def get_item_label(self, item):
        return item.title

    def format_results(self, raw_data, options):
        results = super(HeaderLookup, self).format_results(raw_data, options)
        results['data'] = {v['value']:v for v in results['data']}.values()
        return results

registry.register(SenderLookup)
registry.register(ReplyLookup)
registry.register(HeaderLookup)
registry.register(FooterLookup)