#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Nuwa.py 10419 2017-10-29 15:30:56Z Kevin $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Kevin $ (last)
# $Date: 2017-10-29 23:30:56 +0800 (Sun, 29 Oct 2017) $
# $Revision: 10419 $

from Iuno.cloud.backend import BaseBackend
from Iuno.cloud.logging.backend import BackendMixin

class Backend(BaseBackend, BackendMixin):

    DEFAULT_PREFERRED_DOMAINS = (
        'sentry.nuwainfo.com',
    )

    SENTRY_CONFIGS = {
        'sentry.nuwainfo.com': {
            'test': {
                'SENTRY_DSN': ('https://28dd3e48e1f144e6b595d120e331662e:'
                               'dbeda9f0462945938ce908b1727a7323@'
                               'sentry.nuwainfo.com/8'),
            },
            'mail': {
                'SENTRY_DSN': ('threaded+https://'
                    '5848523a420a4014ae88e5de2598ac02:'
                    '9186279420b24eb5a4b07fe70552348b@'
                    'sentry.nuwainfo.com/4?timeout=60'),
            },          
        },
    }
