#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: settings.py 9201 2013-05-27 06:38:41Z Eric $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2013-05-27 06:38:41 +0000 (週一, 27 五月 2013) $
# $Revision: 9201 $

import os

CURRENT_PATH = os.path.dirname(__file__)

#===============================================================================
# Production or Debug mode.
#===============================================================================
from Iuno import DEVELOPMENT, STAGE, PRODUCTION

SERVER_MODE = DEVELOPMENT
#===============================================================================

#============================================================================
# Project settings.
#===============================================================================
APP_NAME = 'test_newsletter'
APP_VERSION = "0.2.0." + "$Revision: 9201 $"[11:-2]
#============================================================================

#============================================================================
# Administration.
#============================================================================
ADMINS = (
    ('Bear', 'bear@tracedig.com'),
    ('Yachu', 'yachu.jeng@tracedig.com'),
)

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'ig-^$r)%$pexljzv7k(-y@cu(2o)2%13)zv6142$-uqkq5y6xo'
#============================================================================

#============================================================================
# Email.
#============================================================================
DEFAULT_FROM_EMAIL = 'service@tracedig.com'
EMAIL_HOST_USER = "service@tracedig.com"
EMAIL_HOST_PASSWORD = "25025529"
#============================================================================

#============================================================================
# i18n.
#============================================================================
TIME_ZONE = 'UTC'

LANGUAGE_CODE = 'zh-tw'
#============================================================================

#=========================================================================
#  Django templates.
#=========================================================================
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': ['templates',],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.debug',
                'django.template.context_processors.i18n',
                'django.template.context_processors.media',
                'django.template.context_processors.static',
                'django.template.context_processors.tz',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]
#=========================================================================

#=========================================================================
# Django plugins.
#=========================================================================
INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.admin',
    'django.contrib.staticfiles',
    'Iuppiter.i18n',
    'Iuppiter.debug',
    'Iuppiter.extension',
    'django_ses',
    'tagging',
    'tinymce',
    'Theophrastus',
)

#=========================================================================

#============================================================================
# Iuno.cloud.
#============================================================================
IUNO_CLOUD_ENABLE = True
IUNO_CLOUD_QUEUE_SETTINGS = {
    'preferred': {
        'Nuwa': ('mq.nuwainfo.com',),
    },
}

IUNO_CLOUD_SERVICES = ('queue', 'mail', 'browser') 
IUNO_CLOUD_LOGGING_FILE = os.path.join(os.path.dirname(__file__), 'cloud.log')
#============================================================================

import Iuno
Iuno.attachSettings(locals())

DATABASES['default'].update({'TEST_NAME': 'test_newsletter.db'})

#============================================================================

THEOPHRASTUS_UPLOAD_PATH = '%s/uploads/' % MEDIA_ROOT

THEOPHRASTUS_AMAZON_LOGFILE = os.path.join(CURRENT_PATH, 'amazon.log')

THEOPHRASTUS_MAIL_SERVER_LOGFILE = os.path.join(CURRENT_PATH, 'mailServer.log')

THEOPHRASTUS_MAILER_LOGFILE = os.path.join(CURRENT_PATH, 'mailer.log')

THEOPHRASTUS_APSCHEDULER_LOGFILE = os.path.join(CURRENT_PATH, 'apscheduler.log')

THEOPHRASTUS_API_LOG = os.path.join(CURRENT_PATH, 'api.log')

THEOPHRASTUS_ENABLE_INTEGRATION = True

THEOPHRASTUS_ENABLE_FAKE_SMTP = True

from Theophrastus.AttachSettings import attachSettings
attachSettings(locals())

#============================================================================

from Iuppiter.DjangoUtil import extendInstalledApps
extendInstalledApps(locals(), (
    'adapter',
))

#============================================================================
# Newsletter.
#============================================================================
LOCAL_URL = 'http://127.0.0.1/'

STATIC_URL = '/static/'

# Open flash chart - http://teethgrinder.co.uk/open-flash-chart-2/
NEWSLETTER_MEDIA_URL = '%sedn/' % locals()['MEDIA_URL']

NEWSLETTER_DEFAULT_HEADER_REPLY = "Nuwa<service@tracedig.com>"

NEWSLETTER_DEFAULT_HEADER_SENDER = "Nuwa<service@tracedig.com>"

from django.utils.translation import ugettext_lazy as _

TINYMCE_DEFAULT_CONFIG = {
    'plugins':
        "facebook,autolink,lists,spellchecker,pagebreak,style,layer,table,save"
        ",advhr,advimage,advlink,emotions,iespell,inlinepopups,"
        "insertdatetime,preview,media,searchreplace,print,contextmenu,"
        "paste,directionality,fullscreen,noneditable,visualchars,"
        "nonbreaking,xhtmlxtras,template,upload,variablePlugin",
    'relative_urls': False,
    'remove_script_host': False,
    'skin_variant': "black",
    'style_formats': [{
        'title' : 'Bold text',
        'inline' : 'b'
    }, {
        'title' : 'Red text',
        'inline' : 'span',
        'styles' : {'color' : '#ff0000'}
    }, {
        'title' : 'Red header',
        'block' : 'h1',
        'styles' : {'color' : '#ff0000'}
    }],

    #'formats': {"test": {"title" : 'Table row 1', "selector" : 'tr', "classes" : 'tablerow1'}},
    'theme': "advanced",
    'theme_advanced_buttons1': "save,newdocument,|,bold,italic,underline,"
                               "strikethrough,|,justifyleft,justifycenter,"
                               "justifyright,justifyfull,|,styleselect,"
                               "formatselect,fontselect,fontsizeselect,"
                               "template,|,link,unlink,image,|,",
    'theme_advanced_buttons2': "cut,copy,paste,pastetext,pasteword,|,search,"
                               "replace,|,bullist,numlist,|,outdent,indent,"
                               "blockquote,|,undo,redo,|,"
                               "upload,cleanup,code,|,insertdate,"
                               "inserttime,preview,|,forecolor,backcolor",
    'theme_advanced_buttons3': "tablecontrols,|,hr,removeformat,visualaid,|,"
                               "sub,sup,|,charmap,iespell,media,advhr,|,"
                               "insertlayer,moveforward,movebackward,absolute,"
                               "|,styleprops,spellchecker,",
    'theme_advanced_buttons4': "fullscreen,print,feed,variablePlugin,|,",
    'theme_advanced_toolbar_location': "top",
    'theme_advanced_toolbar_align': "left",
    'theme_advanced_statusbar_location': "bottom",
    'theme_advanced_resizing': True,

    # Skin options
    'skin': "o2k7",
    'skin_variant': "silver",

    # Example content CSS (should be your site CSS)
    #'content_css' : "css/example.css",

    # Drop lists for link/image/media/template dialogs
    #'template_external_list_url': "%sjs/TemplateExternalList.js" % MEDIA_URL,
    #'external_link_list_url': "js/link_list.js",
    #'external_image_list_url': "js/image_list.js",
    #'media_external_list_url': "js/media_list.js",

    # Replace values for the template plugin
    'template_replace_values': {
        'username': "Some User",
        'staffid': "991234"
    },

    'template_templates': [],
}
#============================================================================

MIDDLEWARE_CLASSES = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.auth.middleware.SessionAuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.middleware.locale.LocaleMiddleware',
)

ROOT_URLCONF = 'Project.urls'
