#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 9594 2016-03-18 12:59:58Z Judy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $
# $Date: 2016-03-18 20:59:58 +0800 (五, 18  3 2016) $
# $Revision: 9594 $

from HTMLParser import HTMLParseError

from django.conf import settings
from django.contrib import admin
from django.utils.translation import ugettext as _

from Theophrastus.models import Newsletter
from Theophrastus.editor.admin import NewsletterTinyMCEAdmin
from Theophrastus.cloud.Mailer import CloudMailer

ENABLE_FAKE_MAIL = settings.ENABLE_FAKE_MAIL
ENABLE_FAKE_SMTP = settings.ENABLE_FAKE_SMTP

def attach(data, attachData):
    data = list(data)
    data.extend(attachData)
    newData = tuple(data)
    del data
    return newData

def getFieldset(fieldsets):
    _fieldsets = list(fieldsets)
    for (name, d) in fieldsets:
        if 'classes' in d:
            d.pop('classes')
    return fieldsets

class NewsletterStatisticsAdmin(NewsletterTinyMCEAdmin):

    def statistics_link(self, newsletter):
        """
        Display link for statistics(override).
        """
        """Display link for statistics"""
        if (newsletter.status == Newsletter.SENDING or
            newsletter.status == Newsletter.SENT):
            return '<a href="%s">%s</a>' % (
                   newsletter.getStatisticsUrl(), _('View statistics'))
        else:
            return _('Not available')
    statistics_link.allow_tags = True
    statistics_link.short_description = _('Statistics')

    def subscriberLink(self, newsletter):
        """
        Display link for subscribers.
        """
        if (newsletter.status == Newsletter.SENDING or
            newsletter.status == Newsletter.SENT):
            return '<a href="%s">%s</a>' % (
                   newsletter.getSubscriberUrl(), _('View subscribers'))
        else:
            return _('Not available')

    subscriberLink.allow_tags = True
    subscriberLink.short_description = _('Subscribers')

    def send_mail_test(self, request, queryset):
        """
        Send newsletter in test.
        """
        for newsletter in queryset:
            if newsletter.test_contacts.count():
                try:
                    mailer = CloudMailer(newsletter, test=True,
                                         fakeMail=ENABLE_FAKE_MAIL,
                                         fakeSMTP=ENABLE_FAKE_SMTP)
                    mailer.run()
                except HTMLParseError:
                    self.message_user(
                        request,
                        _('Unable send newsletter, due to errors within HTML.'))
                    continue
                self.message_user(
                    request, _('%s successfully sent.') % newsletter)
            else:
                self.message_user(
                    request,
                    _('No test contacts assigned for %s.') % newsletter)
    send_mail_test.short_description = _('Send test email')

    fieldsets = getFieldset(NewsletterTinyMCEAdmin.fieldsets)

    list_display = attach(
        NewsletterTinyMCEAdmin.list_display, ['subscriberLink'])

admin.site.unregister(Newsletter)
admin.site.register(Newsletter, NewsletterStatisticsAdmin)
