#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_zip.py 9878 2017-04-17 06:04:20Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-17 14:04:20 +0800 (週一, 17 四月 2017) $
# $Revision: 9878 $

import os
import logging
import shutil
import zipfile
import json
import hashlib

from django.core.management.base import BaseCommand, CommandError
from django.template.loader import get_template
from django.conf import settings

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

if hasattr(settings, 'TEMPLATES'):
    TEMPLATES_DIR_PATH = settings.TEMPLATES[0]['DIRS'][0]
else:
    TEMPLATES_DIR_PATH = os.path.abspath(
        os.path.join('.', 'templates'))

if settings.DEBUG:
    if hasattr(settings, 'STATICFILES_DIRS'):
        STATIC_DIT_PATH = settings.STATICFILES_DIRS[0]
    else:
        STATIC_DIT_PATH = os.path.abspath(
            os.path.join('.', 'static'))

FIXTURES_DIT_PATH = os.path.abspath(
    os.path.join('.', 'fixtures'))

ROOT_DIR_PATH = os.path.abspath(
    os.path.join('.'))
    
IMAGES_DIT_PATH = os.path.abspath(
    os.path.join('.', 'images'))

class Command(BaseCommand):

    help = 'Create zip file to destination folder.'
    args = '<destination folder>'

    def handle(self, *args, **options):
        if len(args) < 1:
            raise CommandError(
                "You must specify a folder to get template."
                )

        

        if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
            with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                data = json.load(jsonfile)

        content = ''
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for temp in files:
                with open(os.path.join(root, temp)) as f:
                    content += f.read()
        data['checksum'] = hashlib.md5(content).hexdigest()

        with open(os.path.join(ROOT_DIR_PATH, 'info.json'), 'w') as f:
            line = json.dumps(data)
            f.write(line)

        zip = zipfile.ZipFile(
            os.path.join(ROOT_DIR_PATH, 'template.zip'), mode='w')

        logger.info("-----Start copy templates-----")
        for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):
            for file in files:
                path = os.path.join(root, file)
                dst = "./templates/%s" % file
                logger.info("Zip " + path)
                zip.write(path, dst)
                
        index = len(TEMPLATES_DIR_PATH) + 1
        for root, dirs, files in os.walk(STATIC_DIT_PATH):
            for file in files:
                path = os.path.join(root, file)
                dst = "./static/%s" % path[index:]
                logger.info("Zip " + path)
                zip.write(path, dst)
        for root, dirs, files in os.walk(FIXTURES_DIT_PATH):
            for file in files:
                path = 'fixtures/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
                
        temp = get_template('boilerplate/py/setup.py')
        content = temp.render()
        with open(os.path.join(ROOT_DIR_PATH, 'setup.py'), 'w') as f:
            f.write(content)
            
        temp = get_template('boilerplate/txt/README.txt')
        content = temp.render()
        with open(os.path.join(ROOT_DIR_PATH, 'README.txt'), 'w') as f:
            f.write(content)

        zip.write('./README.txt')
        logger.info("Zip README.txt")
        
        zip.write('./setup.py')
        logger.info("Zip setup.py")

        zip.close()

        dst = args[0]

        zip = zipfile.ZipFile(
            os.path.join(dst, '%s.zip' % data['upc']), mode='w')
        zip.write('info.json')
        
        for root, dirs, files in os.walk(IMAGES_DIT_PATH):
            for file in files:
                path = 'images/%s' % file
                logger.info("Zip " + path)
                zip.write(path)
                
        zip.write('template.zip')
        zip.close()
        
        if os.path.exists(FIXTURES_DIT_PATH):
            shutil.rmtree(FIXTURES_DIT_PATH)
        if os.path.exists(IMAGES_DIT_PATH):
            shutil.rmtree(IMAGES_DIT_PATH)
        if os.path.isfile('./README.txt'):
            os.remove('./README.txt')
        if os.path.isfile('./setup.py'):
            os.remove('./setup.py')
        if os.path.isfile('./info.json'):
            os.remove('./info.json')
        if os.path.isfile('./template.zip'):
            os.remove('./template.zip')
        
        logger.info('-----All OK!-----')