#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: tests.py 9850 2017-04-08 14:24:13Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-08 22:24:13 +0800 (週六, 08 四月 2017) $
# $Revision: 9850 $

import os
import sys
import shutil

from django.test import TestCase
from django.template.loader import get_template

HTML_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', '..', 'tests', 'HtmlTemp'))
    
RESULT_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', '..', 'tests', 'ResultHtml'))

TEST_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', '..', 'tests', 'TestHtml'))

class TestBuildBoilerplate(TestCase):

    def testComment(self):
        for root, dirs, files in os.walk(HTML_DIR_PATH):
            for fileName in files:
                filePath = os.path.join(root, fileName)
                dst = os.path.join(TEST_DIR_PATH, fileName)
                shutil.copyfile(filePath, dst)
                
        os.system(
            "%s manage.py build_boilerplate %s" % (sys.executable, 
                                                   TEST_DIR_PATH))

        for root, dirs, files in os.walk(TEST_DIR_PATH):
            for fileName in files:
                testHtml = open(os.path.join(root, fileName))
                html1 = testHtml.read()
                testHtml.close()

                resultHtml = open(os.path.join(RESULT_DIR_PATH, fileName))
                html2 = resultHtml.read()
                resultHtml.close()
               
                self.assertHTMLEqual(html1, html2)