#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: AttachSettingsTest.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import json

import requests

from Iuno.Version import IUNO_VERSION
from Iuppiter.Logging import createLogger
from django.conf import settings

logger = createLogger(__name__)

class RemoteTestCaseMixin(object):

    TEST_URL = None
    TEST_SETTINGS = None
    
    def runTest(self):
        result = requests.post(
            "%s/remote/test/" % self.TEST_URL, data={"password": "25025529", "settings": self.TEST_SETTINGS})
        allData = json.loads(result.text)
        version = allData.get('IUNO_VERSION', "0.0.0.0")
        localAppVersion = getattr(settings, "APP_VERSION", None)
        remoteAppVersion = allData.get("APP_VERSION", "0.0.0.0")
        if localAppVersion:
            if localAppVersion.split(".") > remoteAppVersion.split("."):
                logger.warning(
                    "Local app version is %s, but remote app version is %s." % (localAppVersion, remoteAppVersion))
        else:
            if IUNO_VERSION.split(".") > version.split("."):
                logger.warning("Iuno version is %s, but latest Iuno version is %s." % (IUNO_VERSION, version))
        logger.info(allData.get('result', None))
        
        errorCount = 0
        
        for testcase in allData.get('track', []):
            if testcase.get('error', []):
                classname = testcase.get('classname', None)
                name = testcase.get('name', None)
                time = testcase.get('time', None)
                msg = '''
======================================================================
ERROR [%ss]: %s (%s)
----------------------------------------------------------------------
                ''' % (time, name, classname)
                logger.info(msg)
                for error in testcase.get('error', []):
                    logger.info("Message: ", error.get("message", None))
                    logger.info("Type: ", error.get("type", None))
                    logger.info(error.get("traceback", None))
                    errorCount += 1
        
        # has error
        self.assertEqual(0, errorCount)