/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jslint4java.ant;

import com.googlecode.jslint4java.JSLintResult;
import com.googlecode.jslint4java.ant.ResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintResultFormatter;
import com.googlecode.jslint4java.formatter.JSLintXmlFormatter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileUtils;

public class XmlResultFormatter
implements ResultFormatter {
    private final JSLintResultFormatter form;
    private final StringBuilder sb = new StringBuilder();
    private OutputStream out;

    public XmlResultFormatter() {
        this.form = this.createFormatter();
    }

    protected JSLintResultFormatter createFormatter() {
        return new JSLintXmlFormatter();
    }

    @Override
    public void begin() {
        if (this.out == null) {
            throw new BuildException("must specify destFile for xml output");
        }
        if (this.sb.length() > 0) {
            this.sb.delete(0, this.sb.length() - 1);
        }
        if (this.form.header() != null) {
            this.sb.append(this.form.header());
        }
    }

    @Override
    public void end() {
        if (this.form.footer() != null) {
            this.sb.append(this.form.footer());
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
            w.write(this.sb.toString());
            ((Writer)w).flush();
        }
        catch (IOException exc) {
            try {
                throw new BuildException("Unable to write log file", (Throwable)exc);
            }
            catch (Throwable throwable) {
                FileUtils.close(w);
                throw throwable;
            }
        }
        FileUtils.close((Writer)w);
        this.out = null;
    }

    @Override
    public void output(JSLintResult result) {
        this.sb.append(this.form.format(result));
    }

    @Override
    public void setFile(File file) {
        try {
            this.out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
    }

    @Override
    public void setStdout(OutputStream defaultOutputStream) {
    }
}

