#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Locale.py 9427 2015-09-15 08:01:29Z Judy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Judy $ (last)
# $Date: 2015-09-15 16:01:29 +0800 (週二, 15 九月 2015) $
# $Revision: 9427 $

from django.template import Library

register = Library()

@register.filter
def localeUrl(string):
    """
    Change language code to FB locale url form.

    @param string Language code
    """
    splited = string.split('-')
    return splited[0] + '_' + splited[1].upper()

@register.filter
def country(lang):
    """
    Change language code to country abbreviation.

    @param lang Language code
    """
    return lang[3:]

@register.filter
def joomlaLocale(lang):
    """
    Customize for joomla template language system.

    @param lang Language code.
    """
    if lang.lower() == 'zh-tw':
        return lang[3:]
    else:
        return lang[0:2]
