#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: DistUtilTest.py 9687 2016-06-23 07:23:02Z Judy $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, and individual contributors.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#   1. Redistributions of source code must retain the above copyright notice,
#      this list of conditions and the following disclaimer.
#
#   2. Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#
#   3. Neither the name of Nuwa Information nor the names of its contributors
#      may be used to endorse or promote products derived from this software
#      without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# $Author: Judy $ (last)
# $Date: 2016-06-23 15:23:02 +0800 (週四, 23 六月 2016) $
# $Revision: 9687 $
# from setup import extraRequirements


import os
import unittest

from django.http import HttpResponse

from Iuppiter.DjangoUtil import getDownloadHttpResponse

class DjangoUtilTest(unittest.TestCase):  
    """
    Test case for DjangoUtil getDownloadHttpResponse
    """
    def setUp(self):
        rootDir = os.path.dirname(__file__)
        self.filePath1 = os.path.join(rootDir, "TestData", "abc.ab")
        self.filePath2 = os.path.join(rootDir, "TestData", "abc")
        self.filePath3 = os.path.join(rootDir, "TestData", "abc.txt")
        with open(self.filePath1, 'rb') as f:
            self.file1Content1 = f.read()
        with open(self.filePath2, 'rb') as f:
            self.file1Content2 = f.read()
        with open(self.filePath3, 'rb') as f:
            self.file1Content3 = f.read()
           
        
    def tearDown(self):
        self.filePath1 = None
        self.filePath2 = None
        self.filePath3 = None
        self.file1Content1 = None
        self.file1Content2 = None
        self.file1Content3 = None
    
    def testGetDownloadHttpResponse(self):
        """
        Test for getDownloadHttpResponse case 1.
        Name parameter is not given.
        """
        path = self.filePath1      
        response = getDownloadHttpResponse(path)
        expected = "attachment; filename=abc.ab; filename*=abc.ab"
        self.assertEqual(response['Content-Disposition'], expected)   
        self.assertEqual(response.content, self.file1Content1)
        
        """
        Name parameter is given and suffixIncluded is set to be True.
        """
        path = self.filePath1       
        name = 'cde.ab'
        response = getDownloadHttpResponse(path, name=name)
        expected = "attachment; filename=cde.ab; filename*=cde.ab"
        self.assertEqual(response['Content-Disposition'], expected) 
        self.assertEqual(response.content, self.file1Content1)
        
        """
        Name parameter is given and suffixIncluded is set to be False.
        """
        path = self.filePath1      
        name = 'cde'
        suffixIncluded = False
        response = getDownloadHttpResponse(path, name=name, suffixIncluded=suffixIncluded)
        expected = "attachment; filename=cde.ab; filename*=cde.ab"
        self.assertEqual(response['Content-Disposition'], expected) 
        self.assertEqual(response.content, self.file1Content1)
        
        """
        Name parameter is given and suffixIncluded is set to be True, while path doesn't include suffix.
        """
        path = self.filePath2      
        name = 'cde'
        suffixIncluded = False
        response = getDownloadHttpResponse(path, name=name, suffixIncluded=suffixIncluded)
        expected = "attachment; filename=cde; filename*=cde"
        self.assertEqual(response['Content-Disposition'], expected) 
        self.assertEqual(response.content, self.file1Content2)
        
        """
        Name parameter is given, suffixIncluded is set to be True, and path include valid suffix.
        """
        path = self.filePath3      
        name = 'cde'
        suffixIncluded = False
        response = getDownloadHttpResponse(path, name=name, suffixIncluded=suffixIncluded)
        expected = "attachment; filename=cde.txt; filename*=cde.txt"
        self.assertEqual(response['Content-Disposition'], expected) 
        self.assertEqual(response.content, self.file1Content3)
        
        

if __name__ == '__main__':
    unittest.main()
