# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('blog_extension', '0007_datepluginconfig'),
    ]

    operations = [
        migrations.CreateModel(
            name='Statistics',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('url', models.CharField(max_length=400, editable=False)),
                ('viewCount', models.PositiveIntegerField(default=0)),
                ('likeCount', models.PositiveIntegerField(default=0)),
                ('commentCount', models.PositiveIntegerField(default=0)),
            ],
        ),
        migrations.AlterField(
            model_name='filterplugin',
            name='allCatagory',
            field=models.BooleanField(default=True, help_text='If you check this. It will not filter articles with catagories.', verbose_name='Not use catagories to filter articles'),
        ),
        migrations.AlterField(
            model_name='filterplugin',
            name='allTag',
            field=models.BooleanField(default=True, help_text='If you check this. It will not filter articles with tags.', verbose_name='Not use tags to filter articles'),
        ),
        migrations.AlterField(
            model_name='filterplugin',
            name='catagory',
            field=models.ForeignKey(related_name='+', default=None, to='aldryn_categories.Category', blank=True, help_text="If you check 'Not use catagories to filter articles'. It will no effect.", null=True, verbose_name='Catagory'),
        ),
        migrations.AlterField(
            model_name='filterplugin',
            name='tag',
            field=models.ManyToManyField(default=None, to='taggit.Tag', blank=True, help_text="If you check 'Not use tags to filter article'. It will no effect.", null=True, verbose_name='Tag'),
        ),
    ]
