#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: FakeTemplateTags.py 10146 2017-08-07 06:38:26Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-07 14:38:26 +0800 (週一, 07 八月 2017) $
# $Revision: 10146 $

from django import template
from django.utils.safestring import mark_safe
from django.templatetags.static import StaticNode
from cms.templatetags.cms_tags import Placeholder, CMSToolbar, PageAttribute
from sekizai.templatetags.sekizai_tags import RenderBlock

register = template.Library()

class Placeholder2(Placeholder):

    lang = 'zh-hant'

    def render_tag(self, context, name, extra_bits, nodelist=None):

        super(Placeholder2, self).render_tag(context, name,
                                                       extra_bits, nodelist)
        return "{% placeholder '" + name + "' %}"
        
class PageAttribute2(PageAttribute):
    
    def get_value(self, context, name, page_lookup):
        return "{% page_attribute '" + name + "' %}"
        
        
class StaticNode2(StaticNode):
    def render(self, context):
        return "{% " + self.path.contents + " %}"

register.tag('placeholder', Placeholder2)
register.tag('static', StaticNode2)
register.tag('page_attribute', PageAttribute2)


