#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: CallToActionLandingSocial.py 12419 2020-07-23 07:57:14Z Casey $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Casey $
# $Date: 2020-07-23 15:57:14 +0800 (Thu, 23 Jul 2020) $
# $Revision: 12419 $

from django import template
from django.utils.safestring import mark_safe
from djangocms_forms.utils import int_to_hashid

from Iuppiter.DjangoUtil import reverse

register = template.Library()

@register.simple_tag
def CallToActionLandingSocial(request, method, actionId, actionFormId, redirectTo=None, form=None):
    social = reverse('social:begin', args=[method])
    fromUrl = request.path
    next = "?next=%s?fromUrl=%s" % (reverse('call_to_action_social'), fromUrl)
    next = next + f'%26callToActionId={actionId}%26actionFormId={actionFormId}'
    if redirectTo:
        next += ("%26redirectTo=" + redirectTo)
    url = social + next
    if form:
        url = url + "%26formId=" + int_to_hashid(form.pk)
    return mark_safe(url)
