#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 13189 2021-08-04 10:31:25Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-08-04 18:31:25 +0800 (Wed, 04 Aug 2021) $
# $Revision: 13189 $

import re

from django.conf import settings
from django.http import HttpResponse
from django.utils.deprecation import MiddlewareMixin

from Iuppiter.DjangoUtil import DJANGO_VERSION
from Iuppiter.Logging import createLogger
from Zephyrus.stats.models import URL

logger = createLogger(__name__)

if hasattr(settings, 'ZEPHYRUS_STATISTICS_URL_INCLUDE'):
    ZEPHYRUS_STATISTICS_URL_INCLUDE = settings.ZEPHYRUS_STATISTICS_URL_INCLUDE
else:
    ZEPHYRUS_STATISTICS_URL_INCLUDE = []

if hasattr(settings, 'ZEPHYRUS_STATISTICS_URL_EXCLUDE'):
    ZEPHYRUS_STATISTICS_URL_EXCLUDE = settings.ZEPHYRUS_STATISTICS_URL_EXCLUDE
else:
    ZEPHYRUS_STATISTICS_URL_EXCLUDE = [
        re.compile(r'^captcha/'),
        re.compile(r'^media/'),
        re.compile(r'^static/'),
        re.compile(r'admin/'),
    ]
    
class StatisticsMiddleware(MiddlewareMixin):
    def process_request(self, request):
        try:
            # match
            path2 = request.path[1:] # 去掉網址最前面的 /
            
            if ZEPHYRUS_STATISTICS_URL_INCLUDE:
                needRecord = False
                for pattern in ZEPHYRUS_STATISTICS_URL_INCLUDE:
                    if pattern.search(path2):
                        needRecord = True
            else:
                # default 
                needRecord = True
            
            for pattern in ZEPHYRUS_STATISTICS_URL_EXCLUDE:
                if pattern.search(path2):
                    needRecord = False

            # view count
            if needRecord:
                url = request.build_absolute_uri(request.path)
                obj, created = URL.objects.get_or_create(
                    url=url,
                )
                obj.viewCount += 1
                obj.save()
        except Exception as e:
            logger.error(str(e))
        return None
 
    def process_response(self, request, response):
        return response
