#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11700 2019-09-05 08:49:19Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-09-05 17:49:19 +0900 (週四, 05 九月 2019) $
# $Revision: 11700 $
#
# Contributors:
#  Bear
#  Yachu

import base64
import importlib

from django.conf import settings
from django.urls import reverse
from django.http import JsonResponse, Http404
from django.views.decorators.csrf import csrf_exempt

from Iuno.cloud.sms import SMS, verify, smsAfterVerify
from Iuppiter.Encryption import Encryptor

@csrf_exempt  
def sendSMSAuthentication(request):
    if request.POST:
        phone = request.POST.get("phone")
        temp = request.POST.get("template")
        
        count = {}
        if request.POST.get("prefixCount"):
            count["prefixCount"] = int(request.POST.get("prefixCount"))
        if request.POST.get("codeCount"):
            count["codeCount"] = int(request.POST.get("codeCount"))

        if not phone:
            raise Http404()
        
        result = verify(phone, template=temp, **count)
        
        # after
        smsAfterVerify.send(sender=sendSMSAuthentication, request=request)
        
        response = JsonResponse(result)
        response["Access-Control-Allow-Origin"] = "*"
        return response
    raise Http404()

@csrf_exempt    
def callAPISMS(request):
    if request.POST:
        from Iuno.cloud.sms.models import Token
        
        phone = request.POST.get("phone")
        message = request.POST.get("message")
        token = request.POST.get("token")
        token = Token.objects.filter(token=token).first()
        
        if phone and message and token:
            encryptor = Encryptor(settings.SECRET_KEY.encode())
            secret = base64.urlsafe_b64decode(token.password)
            password = encryptor.decrypt(secret).decode()
    
            sms = SMS([phone], message, username=token.username, password=password)
            result = sms.sendMessage()
            result = sms.getSendingDetails()[0]
        else:
            result = {
                "stats": False,
                "error_msg": "permission denied",
            }
            
        response = JsonResponse(result)
        response["Access-Control-Allow-Origin"] = "*"
        return response
    raise Http404()