#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: fix_template.py 11376 2019-03-03 14:21:00Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-03-03 22:21:00 +0800 (週日, 03 三月 2019) $
# $Revision: 11376 $

import os
import hashlib
import traceback
import shutil
import six

from django.core.management.base import BaseCommand

from Zephyrus.boilerplate.management.commands import TEMPLATES_DIR_PATH
from Zephyrus.boilerplate.management.commands import createLogger, toBytes
from Zephyrus.boilerplate.management.commands import open3 as open

logger = createLogger(__name__, "FixTemplate.log")
            
class Command(BaseCommand):
    
    help = 'Fix template to no endplaceholder.'
    
    def add_arguments(self, parser):
        parser.add_argument(
            '--overwrite',
            default=False,
            help='Overwrite html or create new html file name xxxFix.html.',
        )
    
    def handle(self, *args, **options):
        try:
            from django import template
            from django.template import Context
                
            fileList = os.listdir(TEMPLATES_DIR_PATH)
            for htmlfile in fileList:
                htmlfile = os.path.join(TEMPLATES_DIR_PATH, htmlfile)
                logger.info(htmlfile)
                # preprocess
                loadTagHash = hashlib.md5(toBytes(
                    "{% load cms_tags menu_tags sekizai_tags %}"
                    "{% load staticfiles %}")).hexdigest()
                jsHash = "%s" % hashlib.md5(toBytes(
                    "{% render_block 'js' %}")).hexdigest()
                cssHash = "%s" % hashlib.md5(toBytes(
                    "{% render_block 'css' %}")).hexdigest()
                toolbarHash = "%s" % hashlib.md5(toBytes(
                    "{% cms_toolbar %}")).hexdigest()
                    
                
                if six.PY2:
                    with open(htmlfile, 'rb') as f:
                        text = f.read()
                else:
                    with open(htmlfile, 'r') as f:
                        text = f.read()
                    
                text = text.replace(
                    "{% load cms_tags menu_tags sekizai_tags staticfiles %}", 
                    "{% load FakeTemplateTags %}" + loadTagHash)
                text = text.replace("{% render_block 'css' %}", cssHash)
                text = text.replace("{% render_block 'js' %}", jsHash)
                text = text.replace("{% cms_toolbar %}", toolbarHash)

                index = htmlfile.index('.html')
                fileBackupName = htmlfile[:index] + '_content.html'
                shutil.copyfile(htmlfile, fileBackupName)
                    
                fileName = htmlfile           
            
                with open(fileName, 'w') as f:
                    f.write(text)
            
                # process
                with open(fileName) as f:
                    t = template.Template(f.read())
                    replaceStr = Context({})
                    
                    text = t.render(replaceStr)
                    
                # endprocess
                text = text.replace(
                    loadTagHash, 
                    ("{% load cms_tags menu_tags sekizai_tags staticfiles %}"
                     "{% with '' as CMS_STATIC_DIR %}"))
                text = text.replace(
                    jsHash, "{% endwith %}{% render_block 'js' %}")
                text = text.replace(
                    cssHash, "{% endwith %}{% render_block 'css' %}")
                text = text.replace(
                    toolbarHash, 
                    ("{% cms_toolbar %}"
                     "{% with '' as CMS_STATIC_DIR %}"))
                     
                if six.PY2:
                    with open(fileName, 'wb') as f:
                        f.write(text.encode('utf8'))
                else:
                    with open(fileName, 'w') as f:
                        f.write(text)
        except Exception as e:
            logger.error("fix_template error:%s" % e)
            with open('./AllError.log', 'w+') as log:
                log.write(traceback.format_exc())
            raise
            