#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11237 2018-10-04 12:45:49Z Lavender $
#
# Copyright (c) 2018 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-10-04 20:45:49 +0800 (週四, 04 十月 2018) $
# $Revision: 11237 $

from django.db import models
from django.utils.translation import ugettext as _

from cms.models import CMSPlugin
from oscar.core.loading import get_model
# from taggit.models import Tag

from Zephyrus.cms_oscar import settings

Category = get_model('catalogue', 'category')
ConditionalOffer = get_model('offer', 'ConditionalOffer')

OR = 1
AND = 2

METHODS = [
    (OR,  _('OR')),
    (AND,  _('AND')),
]


class OscarFeatured(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    filterMethod = models.IntegerField(
        _('Filter Method'), choices=METHODS, default=OR)

    renderTemplate = models.CharField(
        'Featured Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_FEATURED_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_FEATURED_DEFAULT_TEMPLATE,
    )
    
    tag = models.CharField(
        max_length=200,
        default=None,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by tag.")
    )

    catagory = models.ManyToManyField(
        Category,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by category.")
    )
    
class OscarLatest(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    filterMethod = models.IntegerField(
        _('Filter Method'), choices=METHODS, default=OR)

    renderTemplate = models.CharField(
        'Latest Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_LATEST_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_LATEST_DEFAULT_TEMPLATE,
    )

    tag = models.CharField(
        max_length=200,
        default=None,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by tag.")
    )
    
    catagory = models.ManyToManyField(
        Category,
        blank=True,
        null=True,
        help_text=_(
            "If no choice. It will not filter product by category.")
    )

class OscarOffer(CMSPlugin):
    limit = models.PositiveIntegerField(default=6)

    renderTemplate = models.CharField(
        'Offer Template', max_length=150, blank=True,
        choices=settings.ZEPHYRUS_OSCAR_OFFER_TEMPLATES,
        default=settings.ZEPHYRUS_OSCAR_OFFER_DEFAULT_TEMPLATE,
    )

    offer = models.ManyToManyField(
        ConditionalOffer,
    )

    def copy_relations(self, oldinstance):
        self.offer = oldinstance.offer.all()