#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11800 2019-12-12 09:20:09Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License, 
# you may not use this file except in compliance with the License. 
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and 
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-12-12 18:20:09 +0900 (週四, 12 十二月 2019) $
# $Revision: 11800 $ 

from haystack import indexes

try:
    import xapian

    class ProductIndexPatch(object):
        title_exact = indexes.CharField(model_attr='title', null=True)
        price = indexes.IntegerField(null=True, faceted=True)
        
        def prepare_price(self, obj):
            strategy = self.get_strategy()
            result = None
            if obj.is_parent:
                result = strategy.fetch_for_parent(obj)
            elif obj.has_stockrecords:
                result = strategy.fetch_for_product(obj)

            if result:
                if result.price.is_tax_known:
                    return int(result.price.incl_tax)
                return int(result.price.excl_tax)
               
               
except Exception as e:
    class ProductIndexPatch(object):
        pass
        