#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 10872 2018-03-18 16:15:33Z David $
#
# Copyright (c) 2013 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2018-03-19 01:15:33 +0900 (週一, 19 三月 2018) $
# $Revision: 10872 $

from emencia.django.newsletter.models import Newsletter, Contact

from django.db import models
from django.utils.translation import ugettext_lazy as _

class Header(models.Model):

    title = models.CharField(
        _('title'), max_length=255, blank=True, null=True
    )
    content = models.TextField(
        _('Header content'), blank=True, null=True,
        help_text=_('Custom your header content.'))

    def __unicode__(self):
        return _('Header %s') % (str(self.id), ) 

    class Meta:
        verbose_name = _('Header')
        verbose_name_plural = _('Headers')

class Footer(models.Model):

    title = models.CharField(
        _('title'), max_length=255, blank=True, null=True
    )
    content = models.TextField(
        _('Footer content'), blank=True, null=True,
        help_text=_('Custom your footer content.'))

    def __unicode__(self):
         return _('Footer %s') % (str(self.id), ) 

    class Meta:
        verbose_name = _('Footer')
        verbose_name_plural = _('Footers')

# Newsletter track links patch, originally stored in Theophrastus/Patch.py
from emencia.django.newsletter.utils import newsletter
from Theophrastus.Utility import trackLinks

newsletter.track_links = trackLinks