#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 12366 2020-06-19 06:41:16Z Andy $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2020-06-19 15:41:16 +0900 (週五, 19 六月 2020) $
# $Revision: 12366 $

from django.utils.translation import ugettext as _
from django.urls import reverse

from emencia.django.newsletter import models as emModels

import types

from django.db import models

# @models.permalink
def getStatisticsUrl(self):
    return reverse('Theophrastus.views.displayStatistics', kwargs={'slug': self.slug})

# @models.permalink
def getSubscriberUrl(self):
    return reverse('Theophrastus.views.displaySubscribers', kwargs={'slug': self.slug})

emModels.Newsletter.getStatisticsUrl = getStatisticsUrl

emModels.Newsletter.getSubscriberUrl = getSubscriberUrl

def getUnicode(self):
    if self.id == 1:
        return _("Cloud SMTP Server")
    return '%s (%s)' % (self.name, self.host)


emModels.SMTPServer.__unicode__ = getUnicode
