# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import taggit.managers
import aldryn_categories.fields


class Migration(migrations.Migration):

    dependencies = [
        ('taggit', '0002_auto_20150616_2121'),
        ('cms', '0020_old_tree_cleanup'),
        ('aldryn_categories', '0004_auto_20150623_0859'),
    ]

    operations = [
        migrations.CreateModel(
            name='MayLikePlugin',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(parent_link=True, related_name='blog_extension_maylikeplugin', auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin', on_delete=models.CASCADE)),
                ('limit', models.PositiveIntegerField(default=6)),
                ('renderTemplate', models.CharField(default=b'blog_extension/Default.html', max_length=150, verbose_name='Comment Template', blank=True, choices=[(b'blog_extension/Default.html', 'Default')])),
                ('categories', aldryn_categories.fields.CategoryManyToManyField(to='aldryn_categories.Category', verbose_name='categories', blank=True)),
                ('tags', taggit.managers.TaggableManager(to='taggit.Tag', through='taggit.TaggedItem', blank=True, help_text='A comma-separated list of tags.', verbose_name='Tags')),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
