#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_dumpdata.py 12006 2020-03-24 18:55:57Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-03-25 03:55:57 +0900 (週三, 25 三月 2020) $
# $Revision: 12006 $

import os
import sys
import json
import six

if six.PY2:
    from StringIO import StringIO
else:
    from io import StringIO

from django.core.management.base import BaseCommand
from django.core import serializers
from django.db.models.query import QuerySet

from Iuppiter.DjangoUtil import DJANGO_VERSION

if DJANGO_VERSION >= 11100: # django >= 1.11
    from django.apps import apps
else:
    from django.db.models import get_app, get_models

class Command(BaseCommand):

    help = 'Dump all data include filer.File to initial_data.json'

    def add_arguments(self, parser):
        parser.add_argument('path', type=str, help="path")
        parser.add_argument(
            '-n', '--noAuth', 
            action='store_true',
            help="No export auth data.")
    
    def handle(self, *args, **options):
        if DJANGO_VERSION >= 11100:
            app = apps.get_app_config('filer')
            modelList = [apps.get_model('filer', m) for m in app.models]
        else:
            app = get_app('filer')        
            modelList = get_models(app)
        
        dataStream = StringIO()
        
        def getObjects():
            for model in modelList:
                model.objects.queryset_class = QuerySet
                for obj in model.objects.iterator():
                    yield obj
                    
        if DJANGO_VERSION >= 11100:
            serializers.serialize(
                'json', getObjects(), indent=2, 
                use_natural_foreign_keys=True, use_natural_primary_keys=True, 
                stream=dataStream)
        else:
            serializers.serialize(
                'json', getObjects(), indent=2, 
                    use_natural_keys=True, stream=dataStream)
                
        filerData = json.loads(dataStream.getvalue())
        
        try:
        
            os.system(
                "%s manage.py dumpdata -e auth.Permission auth > authData.json" %  
                sys.executable)

            os.system(
                "%s manage.py dumpdata cms.Treenode > treenodeData.json" %  
                sys.executable)
                
            os.system(
                ("%s manage.py dumpdata "
                 "-e auth -e sites -e filer -e "
                 "contenttypes -e cms.Treenode"
                 "> otherData.json") % 
                 sys.executable)
        
            with open('authData.json') as f:
                content = f.read()
                authData = json.loads(content[content.index('['):])
            with open('treenodeData.json') as f:
                content = f.read()
                treenodeData = json.loads(content[content.index('['):])
            with open('otherData.json') as f:
                content = f.read()
                otherData = json.loads(content[content.index('['):])

            data = []

            if not options['noAuth']:
                for ele in authData:
                    data.append(ele)

            
            for ele in filerData:
                data.append(ele)
            for ele in treenodeData:
                data.append(ele)
            for ele in otherData:
                data.append(ele)
            

            path = os.path.join(options['path'])
            
            try:

                with open(path, 'w') as f:
                    content = f.write(json.dumps(data))
                   
            except Exception as e:
                os.remove(path)
                raise e
        
        
            
        finally:
        
            if os.path.exists('authData.json'):
                os.remove('authData.json')
                
            if os.path.exists('treenodeData.json'):
                os.remove('treenodeData.json')
                
            if os.path.exists('otherData.json'):
                os.remove('otherData.json')
                
            
        
