#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: models.py 11999 2020-03-24 13:31:45Z Andy $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Andy $
# $Date: 2020-03-24 22:31:45 +0900 (週二, 24 三月 2020) $
# $Revision: 11999 $

import hashlib

from django.db import models
from django.utils.translation import ugettext_lazy as _

# url and checksum issues
# ​https://stackoverflow.com/questions/38175199/django-increasing-the-size-of-slug-with-unique-true
# ​https://dev.mysql.com/doc/refman/8.0/en/innodb-limits.html
# ​https://github.com/django/django/blob/master/django/db/backends/mysql/validation.py
# https://code.nuwainfo.com/trac/phantasos/ticket/845#comment:21
class URL(models.Model):
    url = models.URLField(max_length=2048)
    viewCount = models.PositiveIntegerField(
        verbose_name=_("View count"), default=0)
    likeCount = models.PositiveIntegerField(
        verbose_name=_("Like count"), default=0)
    commentCount = models.PositiveIntegerField(
        verbose_name=_("Comment count"), default=0)
    checksum = models.CharField(max_length=64, unique=True)
    
    def save(self, *args, **kwargs):
        if self.url:
            self.checksum = hashlib.md5(self.url.encode("utf-8"))
        super().save(*args, **kwargs)

    class Meta:
        verbose_name = _("URL")
        verbose_name_plural = _("URLs")
