#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: build_templates.py 10213 2017-08-22 09:34:20Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-08-22 17:34:20 +0800 (週二, 22 八月 2017) $
# $Revision: 10213 $

import os
import sys
import shutil

from django.core.management.base import BaseCommand, CommandError
from django.conf import settings

from Zephyrus.boilerplate.management.commands import (
    TEMPLATES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "BuildTemplates.log")

class Command(BaseCommand):

    help = 'Start build all template to dst folder.'
    args = '<start folder> <destination folder>'

    def handle(self, *args, **options):
        if len(args) < 2:
            raise CommandError(
                "You must specify a folder to get template."
                )

        startPath = args[0]
        dstPath = args[1]

        for f in os.listdir(startPath):
            tempPath = os.path.join(startPath, f)
            
            dbPath = settings.DATABASES['default']['NAME']
            backupDbPath = os.path.join(ROOT_DIR_PATH, "backup.db")
            if os.path.isfile(backupDbPath):
                if os.path.isfile(dbPath):
                    os.remove(dbPath)
                shutil.copyfile(backupDbPath, dbPath)
            else:
                os.system("%s manage.py migrate" % sys.executable)
                shutil.copyfile(dbPath, backupDbPath)

            # get_template
            error = os.system(
                "%s manage.py get_template %s" % (sys.executable,  tempPath))
            if not error == 0:
                logger.error(
                    "get_template error code: %d, from template: %s" % 
                    (error, tempPath))
                continue

            # build_boilerplate
            error = os.system(
                "%s manage.py build_boilerplate %s" % 
                (sys.executable, TEMPLATES_DIR_PATH))
            if not error == 0:
                logger.error(
                    "build_boilerplate error code: %d, from template: %s" % 
                    (error, tempPath))
                continue
                
            # create_pages
            error = os.system(
                "%s manage.py create_pages" % sys.executable)
            if not error == 0:
                logger.error(
                    "create_pages error code: %d, from template: %s" % 
                    (error, tempPath))
                continue
                
            # pluginize
            error = os.system(
                "%s manage.py pluginize" % sys.executable)
            if not error == 0:
                logger.error(
                    "pluginize error code: %d, from template: %s" % 
                    (error, tempPath))
                continue
                
            # fix_template
            error = os.system(
                "%s manage.py fix_template" % sys.executable)
            if not error == 0:
                logger.error(
                    "fix_template error code: %d, from template: %s" % 
                    (error, tempPath))
                continue

            # dumpdata
            error = os.system(
                ("%s manage.py dumpdata cms djangocms_text_ckeditor "
                 "cmsplugin_filer_image > fixtures/initial_data.json") % 
                 (sys.executable,))
            if not error == 0:
                logger.error(
                    "dumpdata error code: %d, from template: %s" % 
                    (error, tempPath))
                continue

            # create_zip
            error = os.system(
                "%s manage.py create_zip %s" % (sys.executable, dstPath))
            if not error == 0:
                logger.error(
                    "create_zip error code: %d, from template: %s" % 
                    (error, tempPath))
                continue