#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: BuildBoilerplateTest.py 9866 2017-04-16 07:12:52Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2017-04-16 15:12:52 +0800 (週日, 16 四月 2017) $
# $Revision: 9866 $

import os
import sys
import unittest
import logging
import shutil

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

HTML_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', 'HtmlTemp'))

TEST_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', 'TestHtml'))

TEST_STATIC_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', 'static'))

STATIC_DIT_PATH = os.path.abspath(
    os.path.join(__file__, '..', '..', 'static'))

TEMPLATES_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', '..', 'templates'))

class BuildBoilerplateTest(unittest.TestCase):

    def runBuildBoilerplate(self, origin, answer, 
                            dst=TEST_DIR_PATH, delete=True, rename=None):
        fileFrom = os.path.join(HTML_DIR_PATH, origin)
        if rename:
            copyTo = os.path.join(dst, rename)
        else:
            copyTo = os.path.join(dst, origin)
        answer = os.path.join(HTML_DIR_PATH, answer)
        shutil.copyfile(fileFrom, copyTo)
        
                
        os.system(
            "%s Manage.py build_boilerplate %s" % (sys.executable, 
                                                   dst))

        with open(answer, 'r') as f:
            html1 = f.read().replace('\r\n', '\n')
        with open(copyTo, 'r') as f:
            html2 = f.read().replace('\r\n', '\n')
        
        self.assertEqual(html1, html2)
        if delete:
            os.remove(copyTo)

    def reset(self):
        os.system("del Zephyrus.db")
        os.system("copy _Zephyrus.db Zephyrus.db")

        try:
            shutil.rmtree(TEMPLATES_DIR_PATH)
        except Exception as e:
            os.mkdir(TEMPLATES_DIR_PATH)
        else:
            os.mkdir(TEMPLATES_DIR_PATH)

        try:
            shutil.rmtree(STATIC_DIT_PATH)
        except Exception as e:
            logger.error("Static folder is not exist.")
        else:
            os.mkdir(STATIC_DIT_PATH)

    def getTestStatic(self, path):
        self.clearStaticDir()
        path = os.path.join(TEST_STATIC_DIR_PATH, path)
        for dirName in os.listdir(path):
            dirPath = os.path.join(path, dirName)
            dst = os.path.join(STATIC_DIT_PATH, dirName)
            if os.path.isdir(dirPath):
                shutil.copytree(dirPath, dst)
            else:
                shutil.copyfile(dirPath, dst)

    def clearStaticDir(self):
        try:
            shutil.rmtree(STATIC_DIT_PATH)
        except Exception as e:
            logger.error("Static folder is not exist.")
        else:
            os.mkdir(STATIC_DIT_PATH)

    def testComment(self):
        self.runBuildBoilerplate('Comment.html', 'CommentAnswer.html')

    
    def testDiv(self):
        self.runBuildBoilerplate('Div.html', 'DivAnswer.html')
    
    def testSpecialWord(self):
        self.runBuildBoilerplate('SpecialWord.html', 'SpecialWordAnswer.html')
    
    def testStatic(self):
        self.getTestStatic('TestStatic')
        self.runBuildBoilerplate('Static.html', 'StaticAnswer.html')

    # Z只是要讓這個函數最後跑
    def testZAttr(self):
        self.reset()
        self.runBuildBoilerplate('Attr.html', 'AttrAnswer.html', 
                                 dst=TEMPLATES_DIR_PATH, delete=False, 
                                 rename='index.html')
        os.system("%s Manage.py create_pages" % sys.executable)
        os.system("%s Manage.py pluginize" % sys.executable)

        with open(
            os.path.join(STATIC_DIT_PATH, 'js', 'FixTemplate.js'), 'r') as f:
            js1 = f.read().replace('\r\n', '\n')
        with open(os.path.join(HTML_DIR_PATH, 'AttrJsAnswer.js'), 'r') as f:
            js2 = f.read().replace('\r\n', '\n')

        self.assertEqual(js1, js2)
        self.reset()
    
if __name__ == '__main__':
    unittest.main()