#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: DataTypes.py 15491 2025-02-06 04:14:03Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2025-02-06 12:14:03 +0800 (週四, 06 二月 2025) $
# $Revision: 15491 $

from enum import IntEnum
from typing import List, Optional, Union

from pydantic import BaseModel


class LLMProvider(IntEnum):
    OpenAI = 1
    OpenRouter = 2
    LiteLLM = 3

class LLMActionResultType(IntEnum):
    GENERAL = 1
    MAIL = 2

class RuleMatch(BaseModel):
    matached: bool


class LLMActionMailData(BaseModel):
    sender: str
    receivers: List[str]
    subject: str
    body: str
    msg: Optional[str] = None # the complete mail message from Message.as_string()
    date: Optional[str] = None
    textPlain: List[str]
    textHTML: List[str]
    timezone: str

class LLMActionResult(BaseModel):
    resultType: LLMActionResultType
    passToNext: bool = True
    response: Optional[str] = None
    resultMail: Optional[LLMActionMailData] = None
