#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Interfaces.py 16050 2025-05-12 06:48:16Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2025-05-12 14:48:16 +0800 (週一, 12 五月 2025) $
# $Revision: 16050 $

from Pixiu.llm.Clients import (
    BaseLLMClient, InstructorLiteLLMClient, InstructorOpenAIClient, InstructorOpenRouterClient
)

from .DataTypes import LLMProvider


class BaseLLMHandler:

    @classmethod
    def getClient(cls, provider: LLMProvider, **kwargs) -> BaseLLMClient:
        if provider == LLMProvider.OpenAI:
            return InstructorOpenAIClient(**kwargs)
        if provider == LLMProvider.OpenRouter:
            return InstructorOpenRouterClient(**kwargs)
        if provider == LLMProvider.LiteLLM:
            return InstructorLiteLLMClient(**kwargs)
        raise ValueError("Unsupported LLM provider")
