#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: LLMActionTest.py 15536 2025-02-14 06:54:25Z Tim $
#
# Copyright (c) 2025 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2025-02-14 14:54:25 +0800 (週五, 14 二月 2025) $
# $Revision: 15536 $

import unittest

from llm.DataTypes import LLMActionResultType, LLMProvider
from llm.Handlers import LLMActionHandler
from main.DataTypes import MailData

DEFAULT_LLM_MAX_RETRY = 3

class TestLLMActionResult(unittest.TestCase):

    def setUp(self):
        self.provider = LLMProvider.OpenAI
        # self.model = "meta-llama/llama-3.1-405b-instruct:free"
        self.model = "google/gemini-2.0-flash-exp:free"
        self.apiKey = "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"
        self.sender = "test@example"
        self.receivers = ["test@example"]
        self.subject = "Test Subject"
        self.body = "Test Body"
        self.mailData = MailData(self.sender, self.receivers, self.subject, self.body)

    def testLLMActionGeneralResult(self):
        EXPECTED_GENERAL_RESULT = "This is a test mail"
        TEST_GENERAL_PROMPT = f"""
            If the mail body contains any string with 'test', return '{EXPECTED_GENERAL_RESULT}' and do not pass to next action.
            Otherwise return 'This is a normal mail' and pass to next action.
        """
        resultType, data, passToNext = LLMActionHandler.execute(
            provider=self.provider,
            model=self.model,
            apiKey=self.apiKey,
            prompt=TEST_GENERAL_PROMPT,
            mailData=self.mailData,
            maxRetries=DEFAULT_LLM_MAX_RETRY,
            instructorMaxRetries=DEFAULT_LLM_MAX_RETRY,
        )
        self.assertEqual(resultType, LLMActionResultType.GENERAL.value)
        self.assertEqual(isinstance(data, str), True)
        self.assertEqual(passToNext, False)
        self.assertEqual(data, EXPECTED_GENERAL_RESULT)

    def testLLMActionMailResult(self):
        TEST_NEW_BODY = 'This is a new body'
        TEST_MAIL_RESULT_PROMPT = f"""
            replace the mail body with exactly the new body of {TEST_NEW_BODY}
        """
        resultType, data, passToNext = LLMActionHandler.execute(
            provider=self.provider,
            model=self.model,
            apiKey=self.apiKey,
            prompt=TEST_MAIL_RESULT_PROMPT,
            mailData=self.mailData,
            maxRetries=DEFAULT_LLM_MAX_RETRY,
            instructorMaxRetries=DEFAULT_LLM_MAX_RETRY,
        )
        self.assertEqual(resultType, LLMActionResultType.MAIL.value)
        self.assertEqual(isinstance(data, str), False)
        self.assertEqual(data.body, TEST_NEW_BODY)
        self.assertEqual(passToNext, True)
