#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: RuleTest.py 16020 2025-05-08 15:55:19Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2025-05-08 23:55:19 +0800 (週四, 08 五月 2025) $
# $Revision: 16020 $

import logging
import unittest

from main.DataTypes import MailData, RuleType, Target
from main.Handlers import RuleHandler

logger = logging.getLogger(__name__)

TEST_LLM_TEMPERATURE = 0

class RuleTestcase(unittest.TestCase):

    def setUp(self):
        self.TEST_SENDER = "testsender@nuwainfo.com"
        self.TEST_RECEIVERS = ["testreceiver@nuwainfo.com"]

    def testUptimeCertificateExpiration(self):
        # if certificate will be expired in more than 1 day then rule match (it should be archived)
        # if the certificate has expired then rule not match
        TEST_EXPIRATION_MORE_THAN_ONE_DAY_MAIL = MailData(
            sender=self.TEST_SENDER,
            receivers=self.TEST_RECEIVERS,
            subject="[test.com][https://test.com/] server certificate test.com will be expired in 14 days",
            body="[test.com][https://test.com/] server certificate test.com will be expired in 14 days",
        )
        TEST_EXPIRATION_MORE_THAN_ONE_DAY_MAIL_2 = MailData(
            sender=self.TEST_SENDER,
            receivers=self.TEST_RECEIVERS,
            subject="""[sprint.nuwainfo.com][https://sprint.nuwainfo.com] server
            certificate sprint.nuwainfo.com will be expired in 14 days""",
            body="TEST",
        )
        TEST_EXPIRATION_ONE_DAY_MAIL = MailData(
            sender=self.TEST_SENDER,
            receivers=self.TEST_RECEIVERS,
            subject="[test.com][https://test.com/] server certificate test.com will be expired in 1 day",
            body="[test.com][https://test.com/] server certificate test.com will be expired in 1 day",
        )
        TEST_HAS_EXPIRED_MAIL = MailData(
            sender=self.TEST_SENDER,
            receivers=self.TEST_RECEIVERS,
            subject="[Uptime] https://test.com/ - 🔴 Down",
            body="""[test.com] [🔴 Down] certificate has expired
            Time (Asia/Taipei): 2025-02-07 08:02:29
            """,
        )
        # TEST_REGEX = r".*certificate .*? will be expired in (?!1\b)\d+ day[s]?"
        TEST_REGEX = r".*certificate\s+.*?will\s+be\s+expired\s+in\s+(?!1\b)(\d+)\s+day[s]?"
        TEST_REGEX_ONE_DAY = r".*certificate\s+.*?will\s+be\s+expired\s+in\s+1\s+day[s]?"

        matched = RuleHandler.isRuleMatched(
            ruleType=RuleType.IS_REGEX,
            target=Target.SUBJECT,
            value=TEST_REGEX,
            mailData=TEST_EXPIRATION_MORE_THAN_ONE_DAY_MAIL,
        )
        self.assertEqual(matched, True)

        matched = RuleHandler.isRuleMatched(
            ruleType=RuleType.IS_REGEX,
            target=Target.SUBJECT,
            value=TEST_REGEX,
            mailData=TEST_EXPIRATION_MORE_THAN_ONE_DAY_MAIL_2,
        )
        self.assertEqual(matched, True)

        matched = RuleHandler.isRuleMatched(
            ruleType=RuleType.IS_REGEX,
            target=Target.SUBJECT,
            value=TEST_REGEX,
            mailData=TEST_HAS_EXPIRED_MAIL,
        )
        self.assertEqual(matched, False)

        matched = RuleHandler.isRuleMatched(
            ruleType=RuleType.IS_REGEX,
            target=Target.SUBJECT,
            value=TEST_REGEX,
            mailData=TEST_EXPIRATION_ONE_DAY_MAIL,
        )
        self.assertEqual(matched, False)

        matched = RuleHandler.isRuleMatched(
            ruleType=RuleType.IS_REGEX,
            target=Target.SUBJECT,
            value=TEST_REGEX_ONE_DAY,
            mailData=TEST_EXPIRATION_ONE_DAY_MAIL,
        )
        self.assertEqual(matched, True)

        matched = RuleHandler.isRuleMatched(
            ruleType=RuleType.IS_REGEX,
            target=Target.SUBJECT,
            value=TEST_REGEX_ONE_DAY,
            mailData=TEST_HAS_EXPIRED_MAIL,
        )
        self.assertEqual(matched, False)
