#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: setup.py 16060 2025-05-13 06:58:34Z Tim $
#
# Copyright (c) 2024 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Tim $
# $Date: 2025-05-13 14:58:34 +0800 (週二, 13 五月 2025) $
# $Revision: 16060 $

from setuptools import find_packages, setup

PACKAGE_NAME = "Aristotle"

with open('REQUIREMENTS.txt', encoding="utf8") as f:
    requirements = f.read().splitlines()

with open('README.txt', encoding="utf8") as f:
    description = f.read()

setup(
    name="Aristotle",
    version="0.3.14",
    packages=find_packages(),
    install_requires=requirements,
    include_package_data=True,  # Include files specified in MANIFEST.in
    package_data={
        'Aristotle': ['llm/prompts/*', 'llm/prompts/v2/*'],
    },
    author="Tim",
    author_email="tim.lai@nuwainfo.com",
    description="Shared Package for AristotleAPI and Aristotle SMTP Server",
    long_description=description,
    long_description_content_type='text/markdown',
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.11',
)
