#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_plugins.py 11660 2019-07-21 13:24:58Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2019-07-21 21:24:58 +0800 (週日, 21 七月 2019) $
# $Revision: 11660 $


import requests
import json
import re

from cms.plugin_base import CMSPluginBase
from cms.plugin_pool import plugin_pool
from django.utils.translation import ugettext as _
from django.conf import settings
from django.utils.safestring import mark_safe
from django.template.loader import select_template


from instagram import settings as instagramSettings
from instagram.models import InstagramPhoto
from boto.ec2 import instance


class Photo(object):
    def __init__(self, resource, link):
        self.resource = resource
        self.link = link



def getImageData(url):
    r = requests.get(url)

    try:
        from BeautifulSoup import BeautifulSoup
    except ImportError:
        from bs4 import BeautifulSoup
    html = r.text
    soup = BeautifulSoup(html, features="lxml")


    scriptTag = soup.find('script', text=re.compile('window._sharedData'))
    sharedData = scriptTag.string.partition('=')[-1].strip(' ;')

    result = json.loads(sharedData)
    postList = (result.get('entry_data').get('ProfilePage')[0].get(
        'graphql').get('user').get('edge_owner_to_timeline_media').get('edges')
        )
    def getCompleteUrl(shortcode):
        return 'https://www.instagram.com/p/' + shortcode + '/'

    imageData = []
    for edge in postList:
        node = edge.get('node')
        image = {'resource': node.get('display_url'),
                 'link': getCompleteUrl(node.get('shortcode'))}
        imageData.append(image)
    return imageData



class InstagramPhotoPlugin(CMSPluginBase):
    model = InstagramPhoto
    module = _("Instagram Photo")
    name = _("Instagram Photo")
    render_template = instagramSettings.INSTAGRAM_PHOTO_DEFAULT_TEMPLATE

    def get_render_template(self, context, instance, placeholder):
        return select_template([
            instance.renderTemplate,
            instagramSettings.INSTAGRAM_PHOTO_DEFAULT_TEMPLATE,
        ])

    def render(self, context, instance, placeholder):
        formalFormat = re.compile('https://www.instagram.com/\w*/')
        if formalFormat.match(instance.userUrl) == None:
            context.update({
                    'error': _('Url must conform correct format, '
                               'EX: https://www.instagram.com/XXX/'),
            })
            return context

        else:
            imageData = getImageData(instance.userUrl)

            # create objects
            photoList = []
            

            for image in imageData:
                
                photoList.append(Photo(image.get('resource'), image.get('link')))

                if len(photoList) == instance.limit:
                    break

            
            context.update({
                'photoList': photoList,
            })

            return context




plugin_pool.register_plugin(InstagramPhotoPlugin)
