#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: middleware.py 11654 2019-07-17 20:42:48Z Lavender $
#
# Copyright (c) 2019 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-07-18 04:42:48 +0800 (週四, 18 七月 2019) $
# $Revision: 11654 $

import re

from django.conf import settings
from django.http import HttpResponse

from Zephyrus.statistics.models import URL

if hasattr(settings, 'ZEPHYRUS_STATISTICS_URL_INCLUDE'):
    ZEPHYRUS_STATISTICS_URL_INCLUDE = settings.ZEPHYRUS_STATISTICS_URL_INCLUDE
else:
    ZEPHYRUS_STATISTICS_URL_INCLUDE = []

if hasattr(settings, 'ZEPHYRUS_STATISTICS_URL_EXCLUDE'):
    ZEPHYRUS_STATISTICS_URL_EXCLUDE = settings.ZEPHYRUS_STATISTICS_URL_EXCLUDE
else:
    ZEPHYRUS_STATISTICS_URL_EXCLUDE = [
        re.compile(r'^captcha/'),
        re.compile(r'^media/'),
        re.compile(r'^static/'),
        re.compile(r'admin/'),
    ]


class StatisticsMiddleware(object):
    def __init__(self, get_response):
        self.get_response = get_response
        
    def __call__(self, request):
        return self.get_response(request)

    def process_exception(self, request, exception): 
        return HttpResponse(str(exception))
        
    def process_request(self, request):
        # match
        path2 = request.path[1:] # 去掉網址最前面的 /
        
        if ZEPHYRUS_STATISTICS_URL_INCLUDE:
            needRecord = False
            for pattern in settings.ZEPHYRUS_STATISTICS_URL_INCLUDE:
                if pattern.search(path2):
                    needRecord = True
        else:
            # default 
            needRecord = True
        
        for pattern in settings.ZEPHYRUS_STATISTICS_URL_EXCLUDE:
            if pattern.search(path2):
                needRecord = False

        # view count
        if needRecord:
            url = request.build_absolute_uri(request.path)
            obj, created = URL.objects.get_or_create(
                url=url,
            )
            obj.viewCount += 1
            obj.save()
        return None
 
    def process_response(self, request, response):
        return response