#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: BrowserDownloader.py 9650 2016-04-21 03:59:14Z Eric $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-21 11:59:14 +0800 (週四, 21 四月 2016) $
# $Revision: 9650 $

from Iuno import browser

from scrapy import version_info    
from scrapy.http import HtmlResponse                                    
from scrapy.utils.decorator import inthread
from scrapy.utils.misc import load_object
from scrapy.core.downloader.handlers.http11 import HTTP11DownloadHandler


FALLBACK_HANDLER = 'scrapy.core.downloader.handlers.http.HTTPDownloadHandler'                                        
                                        
class BrowserDownloadHandler(HTTP11DownloadHandler):
    """
    A downloader handler use Iuno.browser to fetch a url.
    """
    
    def __init__(self, settings):
        
        self._engine = 'trident'
        self._options = {}
        self._fallback_handler = load_object(FALLBACK_HANDLER)(settings)
        
        if settings.get('BROWSER_ENGINE'):
            self._engine = settings.get('BROWSER_ENGINE')
            
        if settings.get('BROWSER_OPTIONS'):
            self._options = settings.get('BROWSER_OPTIONS')
    
    def download_request(self, request, spider):
        """
        Return a deferred for the HTTP download
        
        @param request Http request.
        @param spider A scrapy spider.
        @return A Iuno download method.
        """

        return self._download_request(request, spider)
    
    @inthread
    def _download_request(self, request, spider):
        """
        Download a request URL using Iuno.browser.
        
        @param request Http request.
        @param spider A scrapy spider.
        @return A http response.
        """
        
        driver = browser
        result = driver.fetch(request.url, engine=self._engine,
                                           options=self._options)
        return HtmlResponse(request.url, encoding='utf-8',
                                         body=result.content)
        