#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: urls.py 10247 2017-09-03 17:57:32Z David $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: David $
# $Date: 2017-09-04 01:57:32 +0800 (Mon, 04 Sep 2017) $
# $Revision: 10247 $

from django.conf.urls import url, patterns

from Theophrastus.cloud import views

urlpatterns = patterns('',
    url(r'^bounces/$', views.getBounces,
        name='Theophrastus.cloud.getBounces'),
    url(r'^complains/$', views.getComplains,
        name='Theophrastus.cloud.getComplains'),
    url(r'^deliveries/$', views.getDeliveries,
        name='Theophrastus.cloud.getDeliveries'),
    url(r'^verify/$', views.verifyEmailAddress,
        name='Theophrastus.cloud.ajax.verifyEmailAddress'),
    url(r'^verify/delete/$', views.deleteVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.deleteVerifiedEmailAddress'),
    url(r'^verify/check/$', views.checkVerifiedEmailAddress,
        name='Theophrastus.cloud.ajax.checkVerifiedEmailAddress'),

    url(r'^notificationTopic/set/$', views.setNotificationTopic,
        name='Theophrastus.cloud.ajax.setNotificationTopic'),
)
