#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Request.py 9621 2016-04-06 13:36:10Z Eric $
#
# Copyright (c) 2012 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Eric $
# $Date: 2016-04-06 21:36:10 +0800 (週三, 06 四月 2016) $
# $Revision: 9621 $
"""
Request for Trident implementation.
"""

import sys
import os
import platform
import threading

from .. import Interprocess

class Impl(Interprocess.Request):
    """
    Request for Trident implementation.
    """
    
    LOCK = threading.RLock()
    
    if sys.platform.startswith('win'):
        if platform.architecture()[0] == '64bit':       
            from win32 import TridentImplClient as CLIENT
            EXE_FOLDER = os.path.join(os.path.dirname(__file__), 'win32')
            
        EXE = os.path.normpath(os.path.join(EXE_FOLDER, 'TridentImpl.exe'))

    def handleError(self, error, url, options, response):        
        # NavigateError Event Status Codes
        # http://msdn.microsoft.com/en-us/library/bb268233%28VS.85%29.aspx
        
        import winerror
        # (E_ACCESSDENIED, 401, 403,
        #  INET_E_AUTHENTICATION_REQUIRED, INET_E_SECURITY_PROBLEM)
        if error in (winerror.E_ACCESSDENIED, 401, 403,
                     0x80070005, 0x800C0009L, 0x800C000EL):
            from .. import AccessDeniedError
            raise AccessDeniedError(url, error)
        # (INET_E_CANNOT_CONNECT, INET_E_CONNECTION_TIMEOUT,
        #  INET_E_RESOURCE_NOT_FOUND, INET_E_DOWNLOAD_FAILURE)
        elif error in (0x800C0004L, 0x800C000BL,
                       0x800C0005L, 0x800C0008L):
            from .. import ConnectionError
            raise ConnectionError(url, error)
        # (INET_E_INVALID_URL, INET_E_UNKNOWN_PROTOCOL)
        elif error in (0x800C0002L, 0x800C000DL):
            from .. import InvalidHyperlinkError
            raise InvalidHyperlinkError(url, error)
        elif 400 <= error <= 505:
            from .. import HttpError
            raise HttpError(url, error)
        else:
            from .. import UnknownError
            raise UnknownError(url, error)

Interprocess.kill(Impl)
