#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: cms_loaddata.py 11415 2019-04-02 17:08:19Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-04-03 02:08:19 +0900 (週三, 03 四月 2019) $
# $Revision: 11415 $

import json

from django.core.management.base import BaseCommand
from django.core.management import call_command

from filer.models.imagemodels import Image

class Command(BaseCommand):
    
    help = 'Fixed filer image from dumpdata'

    def add_arguments(self, parser):
        parser.add_argument('data', type=str, help="data json")
    
    def handle(self, *args, **options):
        dataJson = options['data']
        call_command('loaddata', dataJson)  

        with open(dataJson) as data:
            allData = json.loads(data.read())

        imageData = \
            [d for d in allData if d['model'] == 'filer.image']

        # media 資料夾在 deploy 完會 create，而 initial_data 會解不出來
        
        # file_data_changed 出錯不會有訊息
        for imgData in imageData:
            image = Image.objects.get(id=imgData['pk'])
            image.file_data_changed()
            


        
