#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 11787 2019-12-03 16:12:54Z Lavender $
#
# Copyright (c) 2021 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2019-12-04 00:12:54 +0800 (週三, 04 十二月 2019) $
# $Revision: 11787 $

from django.views import View
from django.contrib import auth
from django.shortcuts import render, redirect
from django.contrib import messages

class TracLoginView(View):
    
    templateName = "member/TracLogin.html"
    redirectTo = "/admin/"
    
    def get(self, request, *args, **kwargs):
        return render(request, self.templateName)
        
    def post(self, request, *args, **kwargs):
        username = request.POST.get("username")
        password = request.POST.get("password")
        user = auth.authenticate(request, username=username, password=password)
        
        if user:
            self.afterPost(request, user)
            auth.login(request, user)
            return redirect(self.redirectTo)    
        else:
            messages.error(request, 'Username and pasword is invalid.')
        return render(request, self.templateName)
        
    def afterPost(self, request, user):
        pass