#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: admin.py 11884 2020-01-20 08:51:15Z Trista $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Trista $
# $Date: 2020-01-20 16:51:15 +0800 (週一, 20 一月 2020) $
# $Revision: 11884 $


from django.contrib import admin

from Zephyrus.map.models import Map, MapPosition


class MapAdmin(admin.ModelAdmin):
    list_display = ('cmsplugin_ptr_id', 'apiKey', 'renderTemplate')

class MapPositionAdmin(admin.ModelAdmin):
    list_display = (
        'relatedMap',
        'region',
        'name',
        'tel',
        'email',
        'coordinate'
    )

admin.site.register(Map, MapAdmin)
admin.site.register(MapPosition, MapPositionAdmin)
