#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: __init__.py 11172 2018-07-16 09:31:00Z Lavender $
#
# Copyright (c) 2015 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $ (last)
# $Date: 2018-07-16 18:31:00 +0900 (週一, 16 七月 2018) $
# $Revision: 11172 $

import logging

logger = logging.getLogger(__name__)

class BackendMixin(object):
    """
    Mixin for logging service backend implementations.
    """

    # Sentry configuration attribute, if it is not None, it will be
    # passed to CeleryBrokerInfo.
    SENTRY_CONFIGS = None

    def getSentryInfo(self, preferred=None, config=None):
        """
        Get sentry information.

        @param preferred Preferred machines.
        @param config Configuration settings.
        @return Dictionary with client settings.
        """
        domains = self.getDomains(preferred)
        for domain in domains:
            domainConfig = self.SENTRY_CONFIGS.get(domain, None)
            if 'project' not in config and 'dsn' not in config:
                logger.warn("You didn't set 'project' or 'dsn' in cloud "
                            "logging settings, skip using cloud logging "
                            "service.")
                return None
            
            project = config.get('project', None)
            if project and project in domainConfig:
                info = domainConfig[project]
            else:
                info = {
                    'SENTRY_DSN': config.get('dsn', None),
                }

            secure = False
            if 'https://' in info['SENTRY_DSN']:
                secure = True
                
            if self._checkHttp(domain, secure=secure):
                return info

        return None
