# -*- coding: utf-8 -*-
# Generated by Django 1.11.20 on 2020-03-19 06:34
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
from django.db.models.manager import Manager

def calcCanUsingBonus(r):
    return r.receive + r.adjust - r.usedBonus - r.expiredBonus

def recordUsingBonus(BonusRecord, record, adjust=False):
    bonusRecords = BonusRecord.objects.filter(
        user=record.user.id, createdTime__lt=record.createdTime
        ).exclude(id=record.id).order_by('createdTime') # old to new
        
    use = record.use
    
    if record.adjust < 0: # 調整紅利為負，表示扣除
        use = use - record.adjust
    
    for r in bonusRecords:
        if use == 0: # 已記錄完畢
            break
        else:
            canUsingBonus = calcCanUsingBonus(r)
            if canUsingBonus > 0:
                if canUsingBonus >= use:
                    r.usedBonus = r.usedBonus + use
                    use = use - use # 0
                else:
                    use = use - canUsingBonus
                    r.usedBonus = r.usedBonus + canUsingBonus # canUsingBonus will be 0
                    
                r.save()
            
    if use != 0:
        if adjust:
            # 用於紀錄對不上時(如使用 admin 自行修改 bonus 而沒有被 record 處理過的)，這部分用於 migrate 時，
            # 調整當筆紀錄之前的紀錄並扣除已使用的 bonus
            # 屬於紀錄補正用
            r = BonusRecord.objects.create(
                user_id=int(record.user.id),
                adjust=use,
                usedBonus=use,
                # note=_("System adjust") 如果先 migrate 19 版還沒有 note，會出問題，因此暫不自動設定
            )
            r.createdTime = record.createdTime
            r.save()
        else:
            raise RuntimeError("Not enough bonus to deduct: %s" % record)

def recordBonus(apps, schemaEditor):
    try:
        BonusRecord = apps.get_model('shop', 'BonusRecord')
        Bonus = apps.get_model('shop', 'Bonus')
    except:
        # do nothing
        return
    
    for b in Bonus.objects.all():      
        bonusRecords = BonusRecord.objects.filter(user=b.user).order_by('createdTime')
        
        for record in bonusRecords:
            recordUsingBonus(BonusRecord, record, adjust=True)
    
        
class Migration(migrations.Migration):

    dependencies = [
        ('shop', '0018_auto_20200108_2106'),
    ]

    operations = [
        migrations.AlterModelManagers(
            name='bonusrecord',
            managers=[
                ('objects', Manager()),
            ],
        ),
        migrations.AddField(
            model_name='bonusrecord',
            name='usedBonus',
            field=models.IntegerField(default=0, verbose_name='Used bonus'),
        ),
         migrations.AddField(
            model_name='bonusrecord',
            name='expiredBonus',
            field=models.IntegerField(default=0, verbose_name='Expired bonus'),
        ),
        migrations.AddField(
            model_name='bonussettings',
            name='expiryDays',
            field=models.IntegerField(default=-1, validators=[django.core.validators.MinValueValidator(-1)], verbose_name='Expiry days(-1 is no limit)'),
        ),
        migrations.RunPython(recordBonus),
    ]
