#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: views.py 12209 2020-05-13 07:27:11Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-05-13 15:27:11 +0800 (週三, 13 五月 2020) $
# $Revision: 12209 $

import json

import requests

from django.shortcuts import redirect, render
from django.views.generic import View
from django.views.decorators.csrf import csrf_exempt
from django.utils.decorators import method_decorator
from django.http import Http404, HttpResponse
from django.conf import settings
from django.utils.translation import ugettext as _
from django.urls import reverse

from Iuppiter.Logging import createLogger
from Zephyrus.facebook import MANAGE_PAGES_STATE, SCOPE
from Zephyrus.facebook import settings as FBSettings
from Zephyrus.facebook import getCommentURL, getAPIData
from Zephyrus.facebook.models import APIData, FacebookSettings

logger = createLogger(__name__)

def createAuthorizationURL(request, scope=SCOPE, state={"code": MANAGE_PAGES_STATE,}, redirectToURL=None):
    scope = ",".join(scope)
    redirectURL = "https://%s%s" % (request.META['HTTP_HOST'], reverse("facebookAuthorization"))
    url = ("https://www.facebook.com/v6.0/dialog/oauth?client_id="
           "%s&redirect_uri=%s&scope=%s") % (
            FBSettings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID, redirectURL, scope)
            
    if redirectToURL:
        state.update({
            "redirectToURL": redirectToURL,
        })
            
    if state:
        url = url + "&state=%s" % json.dumps(state)
    
    return url
    
def createAccessTokenAPIURL(request, code):
    redirectURL = "https://%s%s" % (request.META['HTTP_HOST'], reverse("facebookAuthorization"))
    url = ("https://graph.facebook.com/v6.0/oauth/access_token"
           "?client_id=%s&redirect_uri=%s&client_secret=%s&code=%s") % (
           FBSettings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_ID, redirectURL, 
           FBSettings.ZEPHYRUS_FACEBOOK_DEFAULT_APP_SECRET, code)
    return url
    
class FacebookAccessTokenCreateView(View):

    def get(self, request, *args, **kwargs):
        referer = request.META.get('HTTP_REFERER')
        # 要使用這個需要同一個站內的連結
        if referer:
            redirectURL = "%s://%s%s" % (
                request.scheme, request.META['HTTP_HOST'], reverse('facebookAccessTokenReturn'))
            
            # 使用這個 view 需要以下兩種參數
            data = "redirect=%s&password=%s" % (redirectURL, FBSettings.ZEPHYRUS_FACEBOOK_DEFAULT_PASSWORD)
            
            return redirect("%s%s?%s" % (
                FBSettings.ZEPHYRUS_FACEBOOK_DEFAULT_GET_ACCESS_TOKEN_URL, 
                reverse('facebookAuthorizationRedirect'), data))
        else:
            raise Http404()
        
class FacebookAccessTokenReturnView(View):

    def get(self, request, *args, **kwargs):
        accessToken = request.GET.get("token")
        msg = request.GET.get("msg")
        
        if accessToken:
            # save accessToken
            config, created = FacebookSettings.objects.get_or_create()
            config.accessToken = accessToken
            config.save()
            
        return render(request, "facebook/Authorization.html", {"msg": msg,})
        
class AuthorizationRedirectView(View):

    def get(self, request, *args, **kwargs):
        # 要使用這個 view 需要有 password redirectToURL
        redirectToURL = request.GET.get("redirect")
        password = request.GET.get("password")
        if redirectToURL and password == FBSettings.ZEPHYRUS_FACEBOOK_DEFAULT_PASSWORD:
            return redirect(createAuthorizationURL(request, redirectToURL=redirectToURL))
        raise Http404()
    

class FacebookAuthorizationView(View):
    
    SUCCESS_MESSAGE = _("Authorization successfully, this window will close automatically.")
    ERROR_MESSAGE = _("Authorization failed, please try again. This window will close automatically.")

    def get(self, request, *args, **kwargs):
        state = json.loads(request.GET.get("state", "{}"))
        redirectToURL = state.get("redirectToURL")
        code = state.get("code")
        if MANAGE_PAGES_STATE == code and redirectToURL:
            # dealwith auth as access token
            code = request.GET.get("code")
            url = createAccessTokenAPIURL(request, code)
            
            try:
                data = requests.get(url)
                data = json.loads(data.text)
                accessToken = data.get("access_token")
                
                if accessToken:
                    logger.info("Success get access token from facebook API: %s" % data)
                    msg = self.SUCCESS_MESSAGE
                else:
                    logger.error("Can't get access token from facebook API: %s" % data)
                    msg = self.ERROR_MESSAGE
            except Exception as e:
                logger.error("Can't get access token from facebook API: %s" % e)
                msg = self.ERROR_MESSAGE
                
            redirectToURL = "%s?token=%s&msg=%s" % (redirectToURL, accessToken, msg)
            return redirect(redirectToURL)
        raise Http404()
   
if "Zephyrus.comment" in settings.INSTALLED_APPS:
    from Zephyrus.comment.models import Comment
    
    class FacebookWebHookView(View):
        def get(self, request, *args, **kwargs):
            verify = request.GET.get('hub.verify_token')
            if verify == FBSettings.ZEPHYRUS_FACEBOOK_WEBHOOK_VERIFY_TOKEN:
                return HttpResponse(request.GET.get('hub.challenge'))
            else:
                return HttpResponse('Error, invalid token')
            
        @method_decorator(csrf_exempt)
        def dispatch(self, request, *args, **kwargs):
            return super(
                FacebookWebHookView, self).dispatch(request, *args, **kwargs)

        def post(self, request, *args, **kwargs):
            msg = request.body.decode('utf-8')
            
            data = json.loads(msg)

            entry = data.get("entry")
            if entry:
                for e in entry:
                    changes = e.get("changes")
                    if changes:
                        for c in changes:
                            field = c.get("field")
                            message = c.get("value", {}).get("message")
                            mid = c.get("value", {}).get("id")
                            name = c.get("value", {}).get("from", {}).get("name")

                            if field == "plugin_comment":
                                url = getCommentURL(mid)
                                commentCount = getAPIData(url, "comment_count")
                               

                                # save API data
                                obj, created = APIData.objects.get_or_create(
                                    url=url,
                                )
                                obj.commentCount = commentCount
                                
                                obj.save()

                                # save facebook comment
                                comment = Comment.objects.create(
                                    url=url,
                                    message=message,
                                    facebook=True,
                                    facebookMsgId=str(mid),
                                    facebookUser=name,
                                )
                                
            return HttpResponse('Success')