#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: FixTemplateTest.py 11055 2018-05-14 09:46:32Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-05-14 17:46:32 +0800 (週一, 14 五月 2018) $
# $Revision: 11055 $

import os
import sys
import unittest
import logging
import shutil

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler()
handler.setFormatter(
    logging.Formatter("%(asctime)s - %(levelname)s - %(message)s"))
logger.addHandler(handler)

HTML_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', 'HtmlTemp'))

TEST_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', 'TestHtml'))

TEMPLATES_DIR_PATH = os.path.abspath(
    os.path.join(__file__, '..', '..', 'templates'))

class FixTemplateTest(unittest.TestCase):
    def runBuildBoilerplate(self, origin, answer, 
                            dst=TEST_DIR_PATH, delete=True, rename=None):
        fileFrom = os.path.join(HTML_DIR_PATH, origin)
        if rename:
            copyTo = os.path.join(dst, rename)
        else:
            copyTo = os.path.join(dst, origin)
        answer = os.path.join(HTML_DIR_PATH, answer)
        shutil.copyfile(fileFrom, copyTo)
                
        os.system(
            "%s Manage.py fix_template --overwrite=True" % sys.executable)

        with open(answer, 'r') as f:
            html1 = f.read()
        with open(copyTo, 'r') as f:
            html2 = f.read()
        
        self.assertEqual(html1, html2)
        if delete:
            os.remove(copyTo)

    def testFixTemplate(self):
        self.runBuildBoilerplate(
            'FixTemplate.html', 'FixTemplateAnswer.html', 
            dst=TEMPLATES_DIR_PATH)

if __name__ == '__main__':
    unittest.main()
    