#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: Deploy.py 1003 2021-03-31 18:30:57Z Lavender $
#
# Copyright (c) 2021 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2021-04-01 02:30:57 +0800 (週四, 01 四月 2021) $
# $Revision: 1003 $

import socket
import tldextract

import requests
import mechanicalsoup

from Pandora.Pyflare import Cloudflare

# services settings
CLOUDFLARE_EMAIL = "lavender.chan@nuwainfo.com"
CLOUDFLARE_API_KEY = "82a8aa6dfd398086161f196d7ce60e34bd74e"

SENTRY_URL = "https://sentry.nuwainfo.com"
SENTRY_EMAIL = "devops@nuwainfo.com"
SENTRY_PASSWORD = '9Ao0pvvSmYh4kJngGAlHfLfVCrxgzB'

HEALTHCHECKS_URL = "https://healthchecks.nuwainfo.com"
HEALTHCHECKS_EMAIL = "devops@nuwainfo.com"
HEALTHCHECKS_PASSWORD = "jWr8vftC7GYXs016jiwQXsLcltDpLB"

class BaseServices(object):
    
    name = "Base"

    def register(managerEmail, ifttt, companyName, projectName, server, domain):
        return {
            
        }
    
    
class CloudflareService(BaseServices):

    name = "Cloudflare DNS"

    def register(managerEmail, ifttt, companyName, projectName, server, domain):
        # cf
        cf = Cloudflare(CLOUDFLARE_EMAIL, CLOUDFLARE_API_KEY)
        subdomain = tldextract.extract(domain).subdomain
        zone = '%s.%s' % (tldextract.extract(domain).domain, tldextract.extract(domain).suffix)
        
        # zone id
        response = cf.zones(zone)
        
        result = response.get("result")
        if result:
            zoneID = result[0].get("id", None)
        else:
            zoneID = None
            
        if not zoneID:
            raise RuntimeError("Zone not in Cloudflare: %s" % zone)
        
        # get server ip
        try:
            ip = socket.gethostbyname(server)
        except Exception as e:
            raise RuntimeError("Can't get ip of server: %s" % server)
        
        # check dns 
        if ip and zoneID:
            result = cf.dns_records(zoneID, domain).get('result')
            if not result:
                # creat dns
                result = cf.create_record(zoneID, domain, ip)
                if not result.get('success'):
                    raise RuntimeError("Create Cloudflare DNS error: %s" % result)
                result = cf.dns_records(zoneID, domain).get('result')
            result = result[0]
           
            return {
                'zone name': result.get("zone_name"), 
                'name': result.get("name"), 
                'type': result.get("type"), 
                'content': result.get("content")
            }
            
        raise RuntimeError("Can't get ip of server and zoneID: %s" % server)

class HealthchecksService(BaseServices):

    name = "Healthchechs DNS"

    def register(managerEmail, ifttt, companyName, projectName, server, domain):
        # connect 
        browser = mechanicalsoup.StatefulBrowser(user_agent='MechanicalSoup')
        browser.open("%s/accounts/login/" % HEALTHCHECKS_URL)
        
        # login
        browser.select_form('#login-form')
        browser["email"] = HEALTHCHECKS_EMAIL
        browser["password"] = HEALTHCHECKS_PASSWORD
        browser.submit_selected()

        # create project
        def findProject(project):
            projectLink = None
            for link in browser.page.select('a'):
                if link.text.strip() == project:
                    projectLink = link.attrs['href']
            return projectLink

        hchkProjectName = "[%s] %s" % (companyName, projectName)
        projectLink = findProject(hchkProjectName) 
        
        if not projectLink:
            browser.select_form('#add-project-modal form')
            browser["name"] = hchkProjectName
            browser.submit_selected()
            
            projectLink = findProject(hchkProjectName)
            
        projectLink = projectLink.replace("checks/", "") # /EX: projects/9e7208d8-8b72-4872-8859-b781ae952b60/checks/

        # create API
        browser.open("%s/%ssettings" % (HEALTHCHECKS_URL, projectLink))
        for div in browser.page.select("div.panel-body"):
            if div.h2.text.strip() == "API Access":
                browser.select_form(div.form)
                browser.submit_selected()
                break
                
        # show key     
        for div in browser.page.select("div.panel-body"):
            if div.h2.text.strip() == "API Access":
                hchkProjectAPIKey = div.p.code.text
                break
                
        # invite-team-member-modal
        browser.select_form('#invite-team-member-modal form')
        browser["email"] = managerEmail
        browser.submit_selected()
        
        # integrations
        browser.open("%s/%sadd_email" % (HEALTHCHECKS_URL, projectLink))
        browser.select_form('.container form')
        browser["value"] = managerEmail
        browser.submit_selected()
        
        # create apprise
        browser.open("%s/%s/add_apprise/" % (HEALTHCHECKS_URL, projectLink))
        browser.select_form('.container form')
        browser["url"] = ifttt
        browser.submit_selected()
                
        return {
            'Healthchechs API key': hchkProjectAPIKey, 
            'Document': "Please see Deploy document '如何執行排程程式(Crontab 寫法)' and set API key to settings.py.",
            "Suggestion": "Please go to %s to check emails." % managerEmail,
        }
        
class SentryService(BaseServices):

    name = "Sentry DSN"

    def register(managerEmail, ifttt, companyName, projectName, server, domain):
        # connect 
        browser = mechanicalsoup.StatefulBrowser(user_agent='MechanicalSoup')
        browser.open("%s/auth/login/nuwa/" % SENTRY_URL)
        
        # login
        browser.select_form('form.form-stacked')
        browser["username"] = SENTRY_EMAIL
        browser["password"] = SENTRY_PASSWORD
        browser.submit_selected()
        
        # find team
        created = False
        for link in browser.page.select('a'):
            if link.text.strip() == companyName and "nuwa/teams" in link.attrs['href']:
                created = True
                break
         
        # create team 
        if not created:
            browser.open("%s/organizations/nuwa/teams/new/" % SENTRY_URL)
            browser.select_form('form.form-stacked')
            browser.form["ctwizard-0-name"] = companyName
            browser.submit_selected()
            
            browser.select_form('form.form-stacked')
            op = browser.page.new_tag("input", value="skip")
            op["name"] = "op"
            browser.form.form.append(op)
            
            browser.submit_selected()
            
        # find project
        created = False
        for link in browser.page.select('a'):
            if link.text.strip() == projectName and "nuwa/" in link.attrs['href']:
                created = True
                break
        
        # create project
        if not created:
            teamURL = None
            for link in browser.page.select('a'):
                if link.text.strip() == companyName and "nuwa/teams" in link.attrs['href']:
                    teamURL = link.attrs['href']
                    break
                    
            teamSlug = teamURL.strip("/").split("/")[-1]    
            browser.open("%s/organizations/nuwa/projects/new/?team=%s" % (SENTRY_URL, teamSlug))
            browser.select_form('.body form')
            browser["name"] = projectName
            browser["platform"] = "django"
            browser.submit_selected()
            
        # get dsn
        projectURL = None
        
        for link in browser.page.select('a'):
            if link.text.strip() == projectName and "nuwa/" in link.attrs['href']:
                projectURL = link.attrs['href']
                break
        
        browser.open("%s%ssettings/keys/" % (SENTRY_URL, projectURL))
        
        dsn = browser.page.select("code.clippy")[0].text
        
        return {
            "DSN": dsn,
            'Document': "Please see Iuno document '整合 Iuno 步驟(settings.py)' and set dsn to settings.py.", 
        }