#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: append_template.py 12436 2020-07-30 08:41:42Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2020-07-30 17:41:42 +0900 (週四, 30 七月 2020) $
# $Revision: 12436 $

import os
import shutil
import zipfile
import hashlib

from django.conf import settings
from django.core.management.base import BaseCommand
from django.core.management import call_command
from cms.api import create_page
from cms.models.titlemodels import Title

from Zephyrus.boilerplate.management.commands import createLogger

logger = createLogger(__name__, "Append_template.log")

def findSettings(path):
    for root, dirs, files in os.walk(path):
        for f in files:
            if f == 'settings.py':
                return os.path.join(root, f)
    return None
    
def getCMSTemplates(templateDir):
    templates = []
    
    path = templateDir
    index = None
    
    for root, dirs, files in os.walk(path):
        if path.endswith('/') or path.endswith('\\'):
            relatedPath = root.replace(path, '')
        else:
            # 去掉第一個 / or \
            relatedPath = root.replace(path, '')[1:]
        for fileName in files:
            templatePath = os.path.join(relatedPath, fileName)
            if templatePath.lower() == 'index.html':
                index = templatePath
                continue
            templates.append((templatePath, templatePath))
              
    if index:
        return [(index, index),] + templates
    else:
        return templates

class Command(BaseCommand):

    help = 'Copy html to templates and copy static files to static.'
    
    def add_arguments(self, parser):
        parser.add_argument('zip', type=str, help="template zip path")
        parser.add_argument('name', type=str, help="template page name")
        parser.add_argument(
            '-r', '--root', 
            action='store_true',
            help="Append template to root")

    def handle(self, *args, **options):
        templatePath = options['zip']
        pageName = options['name']
        root = options['root']

        LANGUAGE_CODE = settings.LANGUAGE_CODE

        # copy template
        try:
            templateDir = settings.TEMPLATES[0]['DIRS'][0]
        except Exception as e:
            templateDir = 'templates'
        pageTemplateDir = os.path.join(templateDir, pageName) 
        
        try:
            staticDir = settings.STATICFILES_DIRS[0]
        except Exception as e:
            staticDir = 'static'
            
        hashDir = hashlib.md5(templatePath.encode()).hexdigest()

        zip = zipfile.ZipFile(templatePath)
        # zip.extract('template.zip', '.')
        # zip.close()

        # zip = zipfile.ZipFile('template.zip')
        zip.extractall(hashDir)
        zip.close()

        shutil.copytree(
            os.path.join(hashDir, 'static'), 
            os.path.join(staticDir, pageName))

        shutil.copytree(
            os.path.join(hashDir, 'templates'), 
            os.path.join(templateDir, pageName))

        # modify templates
        for f in os.listdir(os.path.join(templateDir, pageName)):
            if f.endswith('.html'):
                htmlPath = os.path.join(templateDir, pageName, f)
                with open(htmlPath, 'r') as html:
                    content = html.read()

                content = content.replace(
                    "{% with '' as CMS_STATIC_PREFIX %}",
                    "{% with '" + pageName + "/' as CMS_STATIC_PREFIX %}")
                
                if not root:
                    content = content.replace(
                        "{% with '/' as CMS_LINK_PREFIX %}",
                        "{% with '/" + pageName + "/' as CMS_LINK_PREFIX %}")

                with open(htmlPath, 'w') as html:
                    html.write(content)

        # get page template
        pageTemplates = getCMSTemplates(pageTemplateDir)
        pageTemplates = [
            (os.path.join(pageName, t[0]), os.path.join(pageName, t[1])) for t in pageTemplates]
        
        # modify settings
        settingsPath = findSettings('.')
        settingsDir = os.path.dirname(settingsPath)
        bak = os.path.join(settingsDir, 'settings.py.bak')
        if os.path.isfile(bak):
            logger.error("%s exists. failed to backup file." % bak)
            shutil.rmtree(os.path.join(staticDir, pageName))
            shutil.rmtree(os.path.join(templateDir, pageName))
            shutil.rmtree(hashDir)
            # os.remove('template.zip')
            return 

        shutil.copyfile(settingsPath, bak)

        with open(settingsPath, 'r', encoding="utf8") as settingsFile:
            content = settingsFile.read()
               
        with open(settingsPath, 'w', encoding="utf8") as settingsFile: 
            content += \
'''
CMS_TEMPLATES = list(CMS_TEMPLATES)
CMS_TEMPLATES += %s
''' % str(pageTemplates)
            
            settingsFile.write(content)

        # create page
        settings.CMS_TEMPLATES = list(settings.CMS_TEMPLATES)
        settings.CMS_TEMPLATES += pageTemplates

        
        # 主頁面
        homepage = None
        for t in pageTemplates:
            if 'index_content.html' in t[0]:
                logger.info("Create index page: %s" % t[0])
                homepage = create_page(
                    pageName, t[0], 
                    LANGUAGE_CODE, published=True)
                    
                if root:
                    homepage.is_home = True
                    homepage.save()
                    
                    page = homepage.get_public_object()
                    pageTitle1 = Title.objects.get(page=homepage)
                    pageTitle2 = Title.objects.get(page=page)
                    for t in [pageTitle1, pageTitle2]:
                        t.path = ''
                        t.save()
                break
                    
        # 子頁面
        if homepage:
            for t in pageTemplates:
                if not 'index_content.html' in t[0] and t[0].endswith("_content.html"):
                    logger.info("Create page: %s" % t[0])
                    name = t[0][:t[0].index("_content.html")]
                    name = name.replace("%s/" % pageName, "").replace("%s\\" % pageName, "").replace("\\", "_").replace("/", "_")
                    page1 = create_page(
                        name, t[0], settings.LANGUAGE_CODE, 
                        parent=homepage, published=True)
        
        # pluginize
        for t in pageTemplates:
            if '_content.html' in t[0]:
                call_command(
                    'pluginize', template=t[0].replace("%s/" % pageName, "").replace("%s\\" % pageName, ""), 
                    templateDir=pageName)

        # page.template = '%s/index.html' % pageName
        # page.save()

        shutil.rmtree(hashDir)
        # os.remove('template.zip')

