#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: start_app.py 11244 2018-10-10 15:19:58Z Lavender $
#
# Copyright (c) 2016 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2018-10-11 00:19:58 +0900 (週四, 11 十月 2018) $
# $Revision: 11244 $

import os
import zipfile

from django.conf import settings
from django.contrib.sites.models import Site
from django.core.management.base import BaseCommand, CommandError

from Iuno import DEVELOPMENT, STAGE, PRODUCTION
from Iuppiter.Util import classForName

class Command(BaseCommand):
    
    help = 'Scan all app Deploy.py and execute [name] function.'
    
    def add_arguments(self, parser):
        parser.add_argument('name', type=str, help="App name")

    def handle(self, *args, **options):
        name = options['name']

        # Unzip media
        media = hasattr(settings, 'IUNO_INITIAL_MEDIA')
        if media:
            media = settings.IUNO_INITIAL_MEDIA
            if not os.path.isdir("media") and os.path.isfile(media):
                zf = zipfile.ZipFile(media)
                zf.extractall('.')
                zf.close()

        # get sites
        site = Site.objects.filter(id=settings.SITE_ID)[0]    
        siteNames = hasattr(settings, 'IUNO_SITE_DOMAIN_NAMES')
        if siteNames:
            siteNames = settings.IUNO_SITE_DOMAIN_NAMES
            if settings.SERVER_MODE == PRODUCTION:
                site.domain = siteNames[PRODUCTION]
            elif settings.SERVER_MODE == STAGE:
                site.domain = siteNames[STAGE]
            else:
                site.domain = siteNames[DEVELOPMENT]
            site.save()

        # other
        for app in settings.INSTALLED_APPS:
            deploy = '%s.Deploy' % app
            
            try:
                deploy = classForName(deploy)
                if deploy:
                    func = getattr(deploy, name, None)
                    if func:
                        print("execute %s.Deploy.%s" % (app, name))
                        result = func()
            except Exception as e:
                continue