#!/usr/bin/env python
# -*- coding: utf-8 -*-
# $Id: create_pages.py 11436 2019-04-10 17:56:15Z Lavender $
#
# Copyright (c) 2017 Nuwa Information Co., Ltd, All Rights Reserved.
#
# Licensed under the Proprietary License,
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at our web site.
#
# See the License for the specific language governing permissions and
# limitations under the License.
#
# $Author: Lavender $
# $Date: 2019-04-11 02:56:15 +0900 (週四, 11 四月 2019) $
# $Revision: 11436 $

import os
import json
import traceback

import cms

from django.core.management.base import BaseCommand
from django.conf import settings
from django.db import transaction
from cms.api import create_page
from cms.models.titlemodels import Title

from Zephyrus.boilerplate.management.commands import (
        TEMPLATES_DIR_PATH, ROOT_DIR_PATH)
from Zephyrus.boilerplate.management.commands import createLogger
from Zephyrus.boilerplate.management.commands import open3 as open

logger = createLogger(__name__, "CreatePages.log")

class Command(BaseCommand):

    help = 'Auto create all pages.'

    @transaction.atomic
    def handle(self, *args, **options):
        try:
            if os.path.isfile(os.path.join(ROOT_DIR_PATH, 'info.json')):
                with open(os.path.join(ROOT_DIR_PATH, 'info.json')) as jsonfile:
                    data = json.load(jsonfile)
                    slug = data['slug']
            else:
                slug = None

            for root, dirs, files in os.walk(TEMPLATES_DIR_PATH):

                createPage = False
                rootPage = None
                if 'index.html' in [f.lower() for f in files]:
                    for i, f in enumerate([f.lower() for f in files], 0):
                        if f == 'index.html':
                            createPage = True
                            rootPage = files[i]
                else:
                    for f in files:
                        if f.endswith('.html'):
                            rootPage = f
                            createPage = True
                            logger.warn(
                                ("'%s' template use '%s' as root page.") % 
                                (slug, rootPage))
                            break

                if not createPage:
                    logger.error("%s No templates to create pages." % slug)
                    break

                if createPage:
                    path = os.path.join(root, rootPage)
                    data = self.getPageData(path)
                    
                    title = data['title']
                    description = data['description']

                    homePage = create_page(
                        'index', rootPage, settings.LANGUAGE_CODE, 
                        published=True, meta_description=description)

                    if not cms.__version__.startswith('3.4'):
                        homePage.is_home = True
                        homePage.save()

                    page = homePage.get_public_object()
                    pageTitle1 = Title.objects.get(page=homePage)
                    pageTitle2 = Title.objects.get(page=page)
                    for t in [pageTitle1, pageTitle2]:
                        t.page_title = title
                        if not cms.__version__.startswith('3.4'):
                            t.path = ''
                        t.save()

                    logger.info('Create homepage by %s' % rootPage)

                for template in files:
                    name = template[:template.index(".html")]

                    if template == rootPage:
                        continue

                    path = os.path.join(root, template)
                    data = self.getPageData(path)
                    
                    title = data['title']
                    description = data['description']

                    page1 = create_page(
                        name, template, settings.LANGUAGE_CODE, 
                        parent=homePage, published=True, 
                        meta_description=description)

                    page2 = page1.get_public_object()
                    pageTitle1 = Title.objects.get(page=page1)
                    pageTitle2 = Title.objects.get(page=page2)
                    for t in [pageTitle1, pageTitle2]:
                        t.page_title = title
                        t.save()

                    logger.info('Create %s page by %s' % (name, template))
            logger.info('All OK!!')
        except Exception as e:
            logger.error("create_pages error:%s" % e)
            with open('./AllError.log', 'w+') as log:
                log.write(traceback.format_exc())
            raise

    def getPageData(self, path):
        with open(path) as f:
            content = f.read()

        startIndex = content.index('<!--CMS_PAGE_DATA') +\
                     len('<!--CMS_PAGE_DATA') 
        endIndex = content.index('END_CMS_PAGE_DATA-->')

        data = content[startIndex:endIndex]

        content = content.replace(
            '<!--CMS_PAGE_DATA%sEND_CMS_PAGE_DATA-->' % data, '')

        with open(path, 'w') as f:
            f.write(content)

        return json.loads(data)
        

