#!/bin/sh

{% if useConda %}
pip uninstall django --yes
rm -rf /home/nuwa/app/lib/python3.6/site-packages/django/
pip install django==1.11.20

if [ -z $VIRTUAL_ENV ]; then
    python -m pip install --upgrade pip
    pip install -r REQUIREMENTS.txt
fi
{% else %}
if [ -z $VIRTUAL_ENV ]; then
    virtualenv env
    source env/bin/activate
    python -m pip install --upgrade pip
    pip install -r REQUIREMENTS.txt
fi

: ${VIRTUAL_ENV:?"You must run inside virtualenv."}
{% endif %}

python manage.py migrate --noinput
if [[ $? -ne 0 ]] ; then
    # Unknown why (not investigate yet), MySQL will complain foreign key 
    # constrain error on first time migrate, so we migrate twice if needed.
    python manage.py migrate --noinput
fi
python manage.py collectstatic --noinput

# load initial data and set default settings when run the project first.
python manage.py deploy configure